/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.LogbackException;
import com.ejie.x38.log.LogConstants;
import com.ejie.x38.log.security.CurrentUserManager;
import com.ejie.x38.security.Credentials;
import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.TableManager;
import com.ejie.x38.util.ThreadStorageManager;
import java.util.HashMap;
import java.util.Hashtable;
import org.slf4j.MDC;
import org.springframework.security.core.context.SecurityContextHolder;

public class LogLayout
extends LayoutBase<ILoggingEvent> {
    private String appCode = null;
    private String instance = null;

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String doLayout(ILoggingEvent event) throws LogbackException {
        Credentials Credentials2 = null;
        Object[] argArray = event.getArgumentArray();
        HashMap argUdaObjec = new HashMap();
        try {
            if (event.getArgumentArray() != null && (argArray = event.getArgumentArray())[0].getClass() == HashMap.class) {
                argUdaObjec = (HashMap)argArray[0];
            }
            Hashtable<String, String> table = TableManager.initTable();
            table.put("datetime", DateTimeManager.getDateTime());
            table.put("appCode", this.appCode != null ? this.appCode : "");
            table.put("thread", String.valueOf(ThreadStorageManager.getCurrentThreadId()));
            table.put("loggerClass", event.getLoggerName());
            table.put("serverInstance", this.instance != null ? this.instance : "");
            table.put("criticality", event.getLevel() != null ? "" + event.getLevel() : "");
            table.put("message", event.getFormattedMessage() != null ? String.valueOf(event.getFormattedMessage()) : "");
            if (argUdaObjec.get("interFunctionalSubsystem") == null) {
                if (MDC.get((String)"functionalSubsystem") == null) {
                    if (event.getLoggerName().startsWith("com.ejie.") && event.getLoggerName().contains(".service.")) {
                        table.put("functionalSubsystem", "Logic Subsystem");
                    } else if (event.getLoggerName().startsWith("com.ejie.") && event.getLoggerName().contains(".control.")) {
                        table.put("functionalSubsystem", "Web Subsystem");
                    } else if (event.getLoggerName().startsWith("com.ejie.") && event.getLoggerName().contains(".dao.")) {
                        table.put("functionalSubsystem", "Data Subsystem");
                    } else {
                        table.put("functionalSubsystem", "Trace Subsystem");
                    }
                } else {
                    table.put("functionalSubsystem", MDC.get((String)"functionalSubsystem"));
                }
            } else {
                table.put("functionalSubsystem", (String)argUdaObjec.get("interFunctionalSubsystem"));
            }
            if (MDC.get((String)"noInternalAcces") != null && (MDC.get((String)"noInternalAcces").equals("httpAcces") || MDC.get((String)"noInternalAcces").equals("ejbAcces"))) {
                if (MDC.get((String)"user") != null) {
                    table.put("user", MDC.get((String)"user"));
                    table.put("session", MDC.get((String)"session"));
                    table.put("position", MDC.get((String)"position"));
                } else {
                    block30: {
                        try {
                            Credentials2 = (Credentials)SecurityContextHolder.getContext().getAuthentication().getCredentials();
                        }
                        catch (Exception e) {
                            if (e instanceof NullPointerException) break block30;
                            throw new LogbackException("System error logs. Error accessing the security context.", (Throwable)e);
                        }
                    }
                    if (Credentials2 != null) {
                        table.put("user", CurrentUserManager.getCurrentUsername());
                        table.put("session", CurrentUserManager.getCurrentUserN38UidSesion(Credentials2));
                        table.put("position", CurrentUserManager.getPosition(Credentials2));
                    } else {
                        table.put("user", "N/A");
                        table.put("session", "N/A");
                        table.put("position", "N/A");
                    }
                }
                table.put("ipAddress", MDC.get((String)"IPClient"));
            }
            if (argUdaObjec.get("interAditionalInfo") == null) {
                if (MDC.get((String)"aditionalInfo") != null) {
                    table.put("aditionalInfo", MDC.get((String)"aditionalInfo"));
                } else if (event.getThrowableProxy() != null) {
                    ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
                    table.put("aditionalInfo", StackTraceManager.getStackTrace(throwableProxy.getThrowable()));
                } else if (argArray != null && argArray[0].getClass() == String.class) {
                    table.put("aditionalInfo", (String)argArray[0]);
                }
            } else {
                table.put("aditionalInfo", (String)argUdaObjec.get("interAditionalInfo"));
            }
            StringBuffer sbuf = new StringBuffer(1023);
            sbuf.append("##| ");
            int i = 0;
            String[] stringArray = LogConstants.parameters;
            int n = LogConstants.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                sbuf.append(table.get(param) != null ? table.get(param) : "");
                if (++i < LogConstants.parameters.length) {
                    sbuf.append(" ~~ ");
                }
                ++n2;
            }
            sbuf.append(" |##");
            sbuf.append("\r\n");
            return sbuf.toString();
        }
        catch (LogbackException lbe) {
            throw lbe;
        }
        catch (Exception e) {
            throw new LogbackException("System error logs. Error creating the log trace.", (Throwable)e);
        }
    }
}

