/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.dto;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JQGridResponseDto<T> {
    private String page = null;
    private List<T> rows = null;
    private String total = null;
    private Integer records = null;
    private Map<String, Object> additionalParams = new HashMap<String, Object>();
    public static final String CHILDREN = "children";

    public JQGridResponseDto() {
    }

    public <U> JQGridResponseDto(JQGridRequestDto jqGridRequestDto, Long recordNum, List<T> rows) {
        this(jqGridRequestDto, recordNum, (Long)null, rows);
    }

    public <U> JQGridResponseDto(JQGridRequestDto jqGridRequestDto, Long recordNum, Long total, List<T> rows) {
        this(jqGridRequestDto, recordNum, total, rows, null);
    }

    public <U> JQGridResponseDto(JQGridRequestDto jqGridRequestDto, Long recordNum, List<T> rows, List<TableRowDto<T>> reorderedSelection) {
        this(jqGridRequestDto, recordNum, null, rows, reorderedSelection);
    }

    public <U> JQGridResponseDto(JQGridRequestDto jqGridRequestDto, Long recordNum, Long total, List<T> rows, List<TableRowDto<T>> reorderedSelection) {
        this.page = jqGridRequestDto.getPage() != null ? jqGridRequestDto.getPage().toString() : "";
        this.rows = rows;
        this.setTotal(recordNum, jqGridRequestDto.getRows() != null ? jqGridRequestDto.getRows() : 0L);
        this.records = total != null ? total.intValue() : recordNum.intValue();
        this.addAdditionalParam("reorderedSelection", reorderedSelection);
        this.addAdditionalParam("selectedAll", jqGridRequestDto.getMultiselection().getSelectedAll());
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public List<?> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(Long total, Long rows) {
        double dTotal = total.doubleValue();
        double dRows = rows.doubleValue();
        double totalPages = total > 0L ? Math.ceil(dTotal / dRows) : 0.0;
        this.total = String.valueOf((int)totalPages);
    }

    public Integer getRecords() {
        return this.records;
    }

    public void setRecords(Integer records) {
        this.records = records;
    }

    public void addAdditionalParam(String key, Object param) {
        this.additionalParams.put(key, param);
    }

    public Object getAdditionalParam(String name) {
        return this.additionalParams.get(name);
    }

    public void removeAdditionalParam(String name) {
        this.additionalParams.remove(name);
    }

    @JsonIgnore
    public Map<String, Object> getAdditionalParamsMap() {
        return this.additionalParams;
    }

    @JsonAnyGetter
    public Map<String, Object> anyAdditionalParams() {
        return this.additionalParams;
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        this.additionalParams.put(name, value);
    }

    public void setReorderedSelection(List<TableRowDto<T>> reorderedSelection) {
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName()).append(" Object {");
        result.append(" [ page: ").append(this.page).append(" ]");
        result.append(" [ rows: ").append(this.rows).append(" ]");
        result.append(" [ total: ").append(this.total).append(" ]");
        result.append(" [ records: ").append(this.records).append(" ]");
        result.append("}");
        return result.toString();
    }
}

