/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.dto;

import com.ejie.x38.dto.JQGridRequestDto;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class JQGridManager
implements Serializable {
    private static final long serialVersionUID = 2127819481595995328L;

    public static <T> StringBuilder getPaginationQuery(JQGridRequestDto pagination, StringBuilder query) {
        return JQGridManager.getQueryForPagination(pagination, query, false);
    }

    protected static <T> StringBuilder getQueryForPagination(JQGridRequestDto pagination, StringBuilder query, boolean isJerarquia) {
        query.append((CharSequence)JQGridManager.getOrderBy(pagination, isJerarquia));
        StringBuilder paginationQuery = new StringBuilder();
        Long rows = pagination.getRows();
        Long page = pagination.getPage();
        if (page != null && rows != null) {
            paginationQuery.append("SELECT * FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) where rnum > " + rows * (page - 1L) + " and rnum < " + (rows * page + 1L));
        } else if (rows != null) {
            paginationQuery.append("SELECT * FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) where rnum > 0 and rnum < " + (rows + 1L));
        } else {
            return query;
        }
        return paginationQuery;
    }

    protected static <T> StringBuilder getOrderBy(JQGridRequestDto pagination, boolean isJerarquia) {
        StringBuilder orderBy = new StringBuilder();
        if (pagination.getSidx() != null) {
            if (!isJerarquia) {
                orderBy.append(" ORDER BY ");
            } else {
                orderBy.append("\n\t").append("order siblings by ");
            }
            orderBy.append(pagination.getSidx());
            orderBy.append(" ");
            orderBy.append(pagination.getSord());
            if (isJerarquia) {
                orderBy.append("\n");
            }
        }
        return orderBy;
    }

    protected static <T> StringBuilder getMultiselectionSelectOutter(JQGridRequestDto pagination) {
        return new StringBuilder().append(" , page, pageLine, tableLine ");
    }

    protected static <T> StringBuilder getMultiselectionSelectInner(JQGridRequestDto pagination) {
        return new StringBuilder().append(" , ceil(rownum/").append(pagination.getRows()).append(") page, case when (mod(rownum,").append(pagination.getRows()).append(")=0) then '").append(pagination.getRows()).append("' else TO_CHAR(mod(rownum,").append(pagination.getRows()).append(")) end as pageLine, rownum as tableLine ");
    }

    public static <T> StringBuilder getSearchQuery(StringBuilder query, JQGridRequestDto pagination, Class<T> clazz, List<Object> paramList, String searchSQL, List<Object> searchParamList, String ... pkList) {
        return JQGridManager.getSearchQuery(query, pagination, clazz, paramList, searchSQL, searchParamList, null, pkList);
    }

    public static <T> StringBuilder getSearchQuery(StringBuilder query, JQGridRequestDto pagination, Class<T> clazz, List<Object> paramList, String searchSQL, List<Object> searchParamList, List<String> tableAliases, String ... pkList) {
        String pkStr = JQGridManager.strArrayToCommaSeparatedStr(pkList);
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("\n").append("select ").append(pkStr.replaceAll("_", "")).append((CharSequence)JQGridManager.getMultiselectionSelectOutter(pagination)).append("from ( ");
        sbSQL.append("\n\t").append("select SEARCH_QUERY.*").append((CharSequence)JQGridManager.getMultiselectionSelectInner(pagination));
        sbSQL.append("\n\t").append("from (").append((CharSequence)query);
        sbSQL.append("\n\t").append((CharSequence)JQGridManager.getOrderBy(pagination, false)).append(") SEARCH_QUERY ");
        sbSQL.append("\n").append(") ");
        sbSQL.append("\n").append("where 1=1 ");
        for (String tableAlias : tableAliases) {
            searchSQL = searchSQL.replaceAll("(?i)" + tableAlias.trim() + "\\.", "").trim();
        }
        sbSQL.append("\n\t").append(searchSQL.replaceAll("_", ""));
        paramList.addAll(searchParamList);
        return sbSQL;
    }

    public static <T> StringBuilder getReorderQuery(StringBuilder query, JQGridRequestDto jqGridRequestDto, Class<T> clazz, List<Object> paramList, String ... pkList) {
        String pkStr = JQGridManager.strArrayToCommaSeparatedStr(pkList);
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("\n").append("select ").append(pkStr).append((CharSequence)JQGridManager.getMultiselectionSelectOutter(jqGridRequestDto)).append("from ( ");
        sbSQL.append("\n\t").append("select ").append(pkStr).append((CharSequence)JQGridManager.getMultiselectionSelectInner(jqGridRequestDto));
        sbSQL.append("\n\t").append("from (").append((CharSequence)query);
        sbSQL.append("\n\t").append((CharSequence)JQGridManager.getOrderBy(jqGridRequestDto, false)).append(") ");
        sbSQL.append("\n").append(") ");
        sbSQL.append("\n").append("where ");
        sbSQL.append("(").append(pkStr).append(") IN (");
        for (T selectedBean : jqGridRequestDto.getMultiselection().getSelected(clazz)) {
            sbSQL.append("(");
            int i = 0;
            while (i < pkList.length) {
                String prop = jqGridRequestDto.getCore().getPkNames().get(i);
                sbSQL.append("?").append(",");
                try {
                    paramList.add(BeanUtils.getProperty(selectedBean, (String)prop));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            sbSQL.deleteCharAt(sbSQL.length() - 1);
            sbSQL.append("),");
        }
        sbSQL.deleteCharAt(sbSQL.length() - 1);
        sbSQL.append(")");
        return sbSQL;
    }

    private static String strArrayToCommaSeparatedStr(String[] strArray) {
        StringBuilder retStr = new StringBuilder();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            retStr.append(str).append(",");
            ++n2;
        }
        retStr.deleteCharAt(retStr.length() - 1);
        return retStr.toString();
    }

    public static <T> List<?> getPaginationList(JQGridRequestDto pagination, List<?> list) {
        ArrayList returnList = new ArrayList();
        Long rows = pagination.getRows();
        Long page = pagination.getPage();
        if (page != null && rows != null) {
            int i = (int)(rows * (page - 1L));
            while ((long)i < rows * page) {
                returnList.add(list.get(i));
                ++i;
            }
        } else if (rows != null) {
            int i = 0;
            while ((long)i < rows) {
                returnList.add(list.get(i));
                ++i;
            }
        } else {
            return list;
        }
        return returnList;
    }

    public static <T> StringBuilder getReorderQuery(JQGridRequestDto pagination, StringBuilder query, String ... pkCols) {
        StringBuilder reorderQuery = new StringBuilder();
        if (pagination.getSidx() != null) {
            reorderQuery.append(" ORDER BY ");
            reorderQuery.append(pagination.getSidx());
            reorderQuery.append(" ");
            reorderQuery.append(pagination.getSord());
            query.append((CharSequence)reorderQuery);
        }
        reorderQuery = new StringBuilder();
        reorderQuery.append(" SELECT * FROM (SELECT rownum rnum, a.*  FROM (").append((CharSequence)query).append(")a) ");
        reorderQuery.append(" WHERE ID IN (");
        reorderQuery.deleteCharAt(reorderQuery.length() - 1);
        reorderQuery.append(") ");
        return reorderQuery;
    }

    public static <T> StringBuilder getRemoveMultipleQuery(JQGridRequestDto jqGridRequestDto, Class<T> clazz, StringBuilder query, List<Object> paramList, String ... pkCols) {
        String pkStr = JQGridManager.strArrayToCommaSeparatedStr(pkCols);
        StringBuilder removeQuery = new StringBuilder();
        removeQuery.append("DELETE FROM (").append((CharSequence)query).append(") ");
        removeQuery.append(" WHERE (").append(pkStr).append(") ").append(jqGridRequestDto.getMultiselection().getSelectedAll() != false ? " NOT " : "").append(" IN (");
        for (T selectedBean : jqGridRequestDto.getMultiselection().getSelected(clazz)) {
            removeQuery.append("(");
            int i = 0;
            while (i < pkCols.length) {
                String prop = jqGridRequestDto.getCore().getPkNames().get(i);
                removeQuery.append("?").append(",");
                try {
                    paramList.add(BeanUtils.getProperty(selectedBean, (String)prop));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            removeQuery.deleteCharAt(removeQuery.length() - 1);
            removeQuery.append("),");
        }
        removeQuery.deleteCharAt(removeQuery.length() - 1);
        removeQuery.append(")");
        return removeQuery;
    }
}

