/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.dao;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class RowNumResultSetExtractor<T>
implements ResultSetExtractor<List<TableRowDto<T>>> {
    private RowMapper<T> rowMapper;
    private List<String> pkColums;

    public List<TableRowDto<T>> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
        ArrayList<TableRowDto<T>> listTableRow = new ArrayList<TableRowDto<T>>();
        while (resultSet.next()) {
            TableRowDto<Object> tableRow = new TableRowDto<Object>();
            tableRow.setPage(resultSet.getInt("PAGE"));
            tableRow.setPageLine(resultSet.getInt("PAGELINE"));
            tableRow.setTableLine(resultSet.getInt("TABLELINE"));
            Object model = this.rowMapper.mapRow(resultSet, resultSet.getRow());
            tableRow.setModel(model);
            try {
                for (String pk : this.pkColums) {
                    tableRow.addPrimaryKey(pk, BeanUtils.getProperty((Object)model, (String)pk));
                }
                listTableRow.add(tableRow);
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
            catch (InvocationTargetException e) {
                throw new SQLException(e);
            }
            catch (NoSuchMethodException e) {
                throw new SQLException(e);
            }
        }
        return listTableRow;
    }

    public RowNumResultSetExtractor(RowMapper<T> rowMapper, String ... pk) {
        this.rowMapper = rowMapper;
        this.pkColums = Arrays.asList(pk);
    }

    public RowNumResultSetExtractor(RowMapper<T> rowMapper, Pagination<T> pagination) {
        this.rowMapper = rowMapper;
        this.pkColums = pagination.getMultiselection().getPkNames();
    }

    public RowNumResultSetExtractor(RowMapper<T> rowMapper, JQGridRequestDto jqGridRequestDto) {
        this.rowMapper = rowMapper;
        this.pkColums = jqGridRequestDto.getCore().getPkNames();
    }
}

