/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.dao;

import com.ejie.x38.dao.GenericDao;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.persistence.EntityManager;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GenericDaoImpl<T, PK extends Serializable>
implements GenericDao<T, PK> {
    private EntityManager em;
    private Class<T> classT;

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    public GenericDaoImpl() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.classT = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
    }

    @Override
    public T add(T entity) {
        this.em.persist(entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=true)
    public T find(PK id) {
        return (T)this.em.find(this.classT, id);
    }

    @Override
    public void remove(PK id) {
        Object entity = this.em.find(this.classT, id);
        this.em.remove(entity);
    }

    @Override
    public T update(T entity) {
        return (T)this.em.merge(entity);
    }
}

