/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.method.annotation;

import com.ejie.x38.control.bind.annotation.Json;
import com.ejie.x38.json.JsonMixin;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class JsonMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final MediaType DEFAULT_MEDIA_TYPE = new MediaType("application", "json", DEFAULT_CHARSET);
    private boolean prefixJson = false;

    public void setPrefixJson(boolean prefixJson) {
        this.prefixJson = prefixJson;
    }

    protected Map<Class<?>, Class<?>> getMixins(Json jsonFilter) {
        HashMap mixins = new HashMap();
        if (jsonFilter != null) {
            JsonMixin[] jsonMixinArray = jsonFilter.mixins();
            int n = jsonMixinArray.length;
            int n2 = 0;
            while (n2 < n) {
                JsonMixin jsonMixin = jsonMixinArray[n2];
                mixins.put(jsonMixin.target(), jsonMixin.mixin());
                ++n2;
            }
        }
        return mixins;
    }

    public void handleReturnValue(Object arg0, MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest nativeWebRequest) throws Exception {
        if (methodParameter.getMethod().getAnnotation(Json.class) != null) {
            mavContainer.setRequestHandled(true);
            HttpOutputMessage httpRequest = this.getResponse(nativeWebRequest);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.getSerializationConfig().setMixInAnnotations(this.getMixins(methodParameter.getMethod().getAnnotation(Json.class)));
            ServletOutputStream outputStream = ((ServletServerHttpResponse)httpRequest).getServletResponse().getOutputStream();
            JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            if (this.prefixJson) {
                jsonGenerator.writeRaw("{} && ");
            }
            objectMapper.writeValue(jsonGenerator, arg0);
            outputStream.flush();
            outputStream.close();
        }
    }

    private void writeInternal(ObjectMapper objectMapper, Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator(outputMessage.getBody(), encoding);
        try {
            if (this.prefixJson) {
                jsonGenerator.writeRaw("{} && ");
            }
            objectMapper.writeValue(jsonGenerator, object);
        }
        catch (JsonProcessingException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            JsonEncoding[] ajsonencoding = JsonEncoding.values();
            int j = ajsonencoding.length;
            int i = 0;
            while (i < j) {
                JsonEncoding encoding = ajsonencoding[i];
                if (charset.name().equals(encoding.getJavaName())) {
                    return encoding;
                }
                ++i;
            }
        }
        return JsonEncoding.UTF8;
    }

    public boolean supportsReturnType(MethodParameter methodParameter) {
        return methodParameter.getMethod().getAnnotation(Json.class) != null;
    }

    private HttpOutputMessage getResponse(NativeWebRequest webRequest) {
        HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(servletResponse);
    }
}

