/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception.handler;

import com.ejie.x38.control.exception.handler.MvcExceptionHandler;
import com.ejie.x38.validation.ValidationManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public class MvcValidationExceptionHandler {
    private ValidationManager validationManager;

    public MvcValidationExceptionHandler(ValidationManager validationManager) {
        this.validationManager = validationManager;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ModelAndView handleMethodArgumentNotValidException(MethodArgumentNotValidException methodArgumentNotValidException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.processBindingResult((Exception)methodArgumentNotValidException, methodArgumentNotValidException.getBindingResult(), request, response);
    }

    @ExceptionHandler(value={BindException.class})
    public ModelAndView handleBindException(BindException bindException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.processBindingResult((Exception)bindException, bindException.getBindingResult(), request, response);
    }

    private ModelAndView processBindingResult(Exception exception, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeaders("X-Requested-With").hasMoreElements() && bindingResult.hasFieldErrors()) {
            Map<String, List<String>> errorMap = this.validationManager.getErrorsAsMap((Errors)bindingResult);
            String content = this.validationManager.getMessageJSON(errorMap).toString();
            response.setStatus(406);
            response.setContentLength(content.getBytes(Charset.forName(response.getCharacterEncoding())).length);
            response.getWriter().print(content);
            response.flushBuffer();
            return null;
        }
        return MvcExceptionHandler.handle(exception, request, response);
    }
}

