/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

public class MvcExceptionResolver
extends ExceptionHandlerExceptionResolver {
    private List<Object> handlers;
    private List<ExceptionHandlerMethodResolver> methodResolvers;

    public void setExceptionHandlers(List<Object> handlers) {
        this.handlers = handlers;
        ArrayList<ExceptionHandlerMethodResolver> methodResolvers = new ArrayList<ExceptionHandlerMethodResolver>();
        for (Object object : handlers) {
            methodResolvers.add(new ExceptionHandlerMethodResolver(object.getClass()));
        }
        this.methodResolvers = methodResolvers;
    }

    protected ServletInvocableHandlerMethod getExceptionHandlerMethod(HandlerMethod handlerMethod, Exception exception) {
        ServletInvocableHandlerMethod result = super.getExceptionHandlerMethod(handlerMethod, exception);
        if (result != null) {
            return result;
        }
        int index = 0;
        for (ExceptionHandlerMethodResolver exceptionHandlerMethodResolver : this.methodResolvers) {
            Method method = exceptionHandlerMethodResolver.resolveMethod(exception);
            if (method != null) {
                return new ServletInvocableHandlerMethod(this.handlers.get(index), method);
            }
            ++index;
        }
        return null;
    }
}

