/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception;

import com.ejie.x38.validation.ValidationManager;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
public class MvcExceptionHandler {
    private ReloadableResourceBundleMessageSource messageSource;
    private ValidationManager validationManager;

    public MvcExceptionHandler(ReloadableResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public MvcExceptionHandler(ReloadableResourceBundleMessageSource messageSource, ValidationManager validationManager) {
        this.messageSource = messageSource;
        this.validationManager = validationManager;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ModelAndView handleMethodArgumentNotValidException(MethodArgumentNotValidException methodArgumentNotValidException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.processBindingResult((Exception)methodArgumentNotValidException, methodArgumentNotValidException.getBindingResult(), request, response);
    }

    @ExceptionHandler(value={BindException.class})
    public ModelAndView handleBindException(BindException bindException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.processBindingResult((Exception)bindException, bindException.getBindingResult(), request, response);
    }

    private ModelAndView processBindingResult(Exception exception, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getHeaders("X-Requested-With").hasMoreElements() && bindingResult.hasFieldErrors()) {
            Map<String, List<String>> errorMap = this.validationManager.getErrorsAsMap((Errors)bindingResult);
            response.sendError(406, this.validationManager.getMessageJSON(errorMap).toString());
            return null;
        }
        return this.handle(exception, request, response);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ModelAndView handleAccessDeniedException(AccessDeniedException accessDeniedException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale locale = LocaleContextHolder.getLocale();
        String exceptionClassName = accessDeniedException.getClass().getSimpleName();
        if (request.getHeaders("X-Requested-With").hasMoreElements()) {
            response.sendError(401, this.messageSource.getMessage(exceptionClassName, null, accessDeniedException.getMessage(), locale));
            return null;
        }
        return this.handle((Exception)accessDeniedException, request, response);
    }

    @ExceptionHandler
    public ModelAndView handle(Exception exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale locale = LocaleContextHolder.getLocale();
        String exceptionClassName = exception.getClass().getSimpleName();
        if (request.getHeaders("X-Requested-With").hasMoreElements()) {
            response.sendError(406, this.messageSource.getMessage(exceptionClassName, null, exception.getMessage(), locale));
            return null;
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("error");
        modelAndView.addObject("exception_name", (Object)exception.getClass().getName());
        modelAndView.addObject("exception_message", (Object)exception.getMessage());
        StringBuilder sbTrace = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement trace = stackTraceElementArray[n2];
            sbTrace.append(trace.toString()).append("</br>");
            ++n2;
        }
        modelAndView.addObject("exception_trace", (Object)sbTrace);
        return modelAndView;
    }
}

