/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception;

import com.ejie.x38.json.JSONObject;
import com.ejie.x38.util.IframeXHREmulationUtils;
import com.ejie.x38.validation.ValidationManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class FileExceedsFileSizeLimitHandler
implements HandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(FileExceedsFileSizeLimitHandler.class);
    @Resource
    private ReloadableResourceBundleMessageSource messageSource;
    @Autowired
    private ValidationManager validationManager;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof MaxUploadSizeExceededException) {
            try {
                Locale locale = LocaleContextHolder.getLocale();
                String messageError = this.messageSource.getMessage(MaxUploadSizeExceededException.class.getSimpleName(), null, locale);
                Map<String, Object> rupFeedbackMsg = this.validationManager.getRupFeedbackMsg(messageError, "error");
                JSONObject messageJSON = this.validationManager.getMessageJSON(null, rupFeedbackMsg, "error");
                if (IframeXHREmulationUtils.isIframeEmulationRequired((ServletRequest)request)) {
                    IframeXHREmulationUtils.writeIframeHttpStatus(response, messageError.getBytes(), 413);
                } else {
                    String content = messageJSON.toString();
                    response.setStatus(413);
                    response.setContentLength(content.getBytes(Charset.forName(response.getCharacterEncoding())).length);
                    response.getWriter().print(content);
                    response.flushBuffer();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
            return null;
        }
        return null;
    }
}

