/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.pif;

import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;
import com.ejie.x38.security.XlnetCore;
import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.ExtensionMimeDetector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Document;

public class PifServletHelper {
    private static final Logger logger = LoggerFactory.getLogger(PifServletHelper.class);
    private static final String HTTP_BASE_URL_PARAM_NAME = "base_url";
    private static final String HTTP_SECURITY_TOKEN_PARAM_NAME = "securityToken";
    private static final String SECURITY_TOKEN_APP = "APP";

    /*
     * Exception decompiling
     */
    public void processRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doPost(HttpServletRequest request, HttpServletResponse response) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceEventJmsException, Y31JanoServiceAccesDeniedException {
        try {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            String baseUrl = "";
            String folder = "";
            Long fileTtl = null;
            Boolean preserveName = Boolean.FALSE;
            Boolean appSecurityToken = Boolean.TRUE;
            Boolean isIEEmulate = request.getParameter("_emulate_iframe_http_status") != null ? Boolean.TRUE : Boolean.FALSE;
            while (iter.hasNext()) {
                Y31AttachmentBean result;
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    if (HTTP_BASE_URL_PARAM_NAME.equals(name)) {
                        baseUrl = Streams.asString((InputStream)stream);
                        continue;
                    }
                    if ("hadoop_folder_path".equals(name)) {
                        folder = Streams.asString((InputStream)stream);
                        continue;
                    }
                    if ("hadoop_preserve_name".equals(name)) {
                        preserveName = Boolean.TRUE.toString().toUpperCase().equals(Streams.asString((InputStream)stream).toUpperCase()) ? Boolean.TRUE : Boolean.FALSE;
                        continue;
                    }
                    if ("y31_ttl".equals(name)) {
                        fileTtl = Long.valueOf(Streams.asString((InputStream)stream));
                        continue;
                    }
                    if (!HTTP_SECURITY_TOKEN_PARAM_NAME.equals(name)) continue;
                    appSecurityToken = SECURITY_TOKEN_APP.equals(Streams.asString((InputStream)stream).toUpperCase()) ? Boolean.TRUE : Boolean.FALSE;
                    continue;
                }
                Y31JanoService service = null;
                try {
                    String fileName;
                    if (isIEEmulate.booleanValue()) {
                        fileName = item.getName();
                        int indexOf = fileName.lastIndexOf("\\");
                        if (indexOf != -1) {
                            fileName = fileName.substring(indexOf + 1);
                        }
                    } else {
                        fileName = item.getName();
                    }
                    service = Y31JanoServiceAbstractFactory.getInstance();
                    StringBuilder rutaFichTmp = new StringBuilder(folder).append("/").append(fileName);
                    Document xmlSession = null;
                    xmlSession = this.getXLNetsDocument(request, appSecurityToken);
                    result = service.put(xmlSession, stream, rutaFichTmp.toString(), preserveName.booleanValue(), fileTtl);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException ioe) {
                            logger.warn("Se ha producido un error al cerrar el stream de lectura: " + ioe.getMessage());
                        }
                    }
                }
                if (!isIEEmulate.booleanValue()) {
                    response.setContentType("application/json");
                }
                response.getWriter().write(this.getJsonResponsePut(baseUrl, result));
            }
        }
        catch (FileUploadException fue) {
            logger.error("Se ha producido un error la realizar la subida del fichero: ", (Throwable)fue);
            throw new Y31JanoServiceGenericException((Throwable)fue);
        }
        catch (IOException ioe) {
            logger.error("Se ha producido un error la realizar la subida del fichero: ", (Throwable)ioe);
            throw new Y31JanoServiceGenericException((Throwable)ioe);
        }
    }

    private void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Y31JanoServiceGenericException, Y31JanoServiceFileNameFormatException, Y31JanoServiceMongoDbGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException, Y31JanoServiceOracleGenericException, IOException {
        String path = httpRequest.getParameter("hadoop_file_path");
        Document xlnetsToken = this.getXLNetsDocument(httpRequest, Boolean.TRUE);
        ServletOutputStream out = null;
        Y31AttachmentBean file = Y31JanoServiceAbstractFactory.getInstance().info(xlnetsToken, path);
        if (file != null) {
            try {
                httpResponse.setContentType(PifServletHelper.getMimeTypeFromCompletePath(path));
                out = httpResponse.getOutputStream();
            }
            catch (IOException ioe) {
                logger.error("Se ha producido un error la realizar la subida del fichero: ", (Throwable)ioe);
                httpResponse.setStatus(500);
            }
        } else {
            throw new Y31JanoServiceFileNotFoundException("El path " + path + " no existe en remoto");
        }
        httpResponse.setHeader("Content-disposition", "attachment; filename=" + file.getFileName());
        httpResponse.setContentLength(file.getSize().intValue());
        InputStream is = Y31JanoServiceAbstractFactory.getInstance().get(xlnetsToken, path);
        FileCopyUtils.copy((InputStream)is, (OutputStream)out);
        is.close();
        out.flush();
        out.close();
        httpResponse.setStatus(200);
    }

    private void doDelete(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Y31JanoServiceFileNameFormatException, Y31JanoServiceGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        Document sesion = this.getXLNetsDocument(httpRequest, Boolean.TRUE);
        String path = httpRequest.getParameter("hadoop_file_path");
        Y31JanoServiceAbstractFactory.getInstance().delete(sesion, path);
    }

    private Document getXLNetsDocument(HttpServletRequest httpRequest, Boolean appToken) {
        if (Boolean.TRUE.equals(appToken)) {
            return this.getTokenAppDocument(httpRequest);
        }
        N38API n38api = XlnetCore.getN38API((HttpServletRequest)httpRequest);
        return XlnetCore.getN38ItemSesion((N38API)n38api);
    }

    private Document getTokenAppDocument(HttpServletRequest httpRequest) {
        String webAppName = httpRequest.getSession().getServletContext().getInitParameter("webAppName");
        N38APISesion miAPISesion = new N38APISesion();
        Document docAPISesionApp = miAPISesion.n38APISesionCrearApp(webAppName);
        logger.trace("INI - getTokenAppDocument");
        Document doc = null;
        logger.info(" logueandose en XLNets ...");
        N38API n38api = new N38API(docAPISesionApp);
        logger.info(String.valueOf(webAppName) + " logueada en XLNets.");
        doc = n38api.n38ItemSesion();
        logger.trace("FIN - getTokenAppDocument");
        return doc;
    }

    private static String getMimeTypeFromCompletePath(String path) throws Y31JanoServiceFileNameFormatException {
        try {
            ExtensionMimeDetector emd = new ExtensionMimeDetector();
            Collection mimeTypes = emd.getMimeTypesFileName(path);
            MimeType mimeType = MimeUtil.getMostSpecificMimeType((Collection)mimeTypes);
            return mimeType.toString();
        }
        catch (Exception e) {
            return "application/octet-stream";
        }
    }

    private void translateY31JanoErrorCode(HttpServletResponse httpResponse, Exception e, int errorCode) throws IOException {
        e.printStackTrace();
        httpResponse.setStatus(errorCode);
        String s = "{\"success\": false, \"statusCode\":" + errorCode + ", \"message\":\"" + e.getMessage() + "\" }";
        httpResponse.getWriter().print(s);
        httpResponse.addHeader("HTTP_ERROR_CODE_TRANSLATE", s);
        httpResponse.addHeader("HTTP_ERROR_CODE_TRANSLATE_CODE", "Y31-" + errorCode);
        httpResponse.addHeader("HTTP_ERROR_CODE_TRANSLATE_MESSAGE", e.getMessage());
    }

    private String getJsonResponsePut(String baseUrl, Y31AttachmentBean y31AttachmentBean) {
        JSONArray files = new JSONArray();
        JSONObject file = new JSONObject();
        file.put("url", (Object)(String.valueOf(baseUrl) + "?hadoop_file_path=" + y31AttachmentBean.getFilePath()));
        file.put("name", (Object)y31AttachmentBean.getFileName());
        file.put("type", (Object)y31AttachmentBean.getContentType());
        file.put("size", (Object)y31AttachmentBean.getSize());
        file.put("delete_url", (Object)(String.valueOf(baseUrl) + "?hadoop_file_path=" + y31AttachmentBean.getFilePath()));
        file.put("delete_type", (Object)"DELETE");
        files.put((Object)file);
        return files.toString();
    }
}

