/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.locking.LockedObject;
import com.ejie.x38.webdav.methods.DeterminableMethod;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoUnlock
extends DeterminableMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoUnlock.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoUnlock(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        block14: {
            LOG.trace("-- " + this.getClass().getName());
            if (this._readOnly) {
                resp.sendError(403);
                return;
            }
            String path = this.getRelativePath(req);
            String tempLockOwner = "doUnlock" + System.currentTimeMillis() + req.toString();
            try {
                try {
                    LockedObject<? extends IResourceLocks> lo;
                    if (!this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) break block14;
                    String lockId = this.getLockIdFromLockTokenHeader(req);
                    if (lockId != null && (lo = this._resourceLocks.getLockedObjectByID(transaction, lockId)) != null) {
                        String[] owners = lo.getOwner();
                        String owner = null;
                        if (lo.isShared()) {
                            if (owners != null) {
                                int i = 0;
                                while (i < owners.length) {
                                    lo.removeLockedObjectOwner(owners[i]);
                                    ++i;
                                }
                            }
                        } else {
                            owner = owners != null ? owners[0] : null;
                        }
                        if (this._resourceLocks.unlock(transaction, lockId, owner)) {
                            StoredObject so = this._store.getStoredObject(transaction, path);
                            if (so.isNullResource()) {
                                this._store.removeObject(transaction, path);
                            }
                            resp.setStatus(204);
                        } else {
                            LOG.trace("DoUnlock failure at " + lo.getPath());
                            resp.sendError(420);
                        }
                        break block14;
                    }
                    resp.sendError(400);
                }
                catch (LockFailedException e) {
                    e.printStackTrace();
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        }
    }
}

