/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.AbstractMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoPut
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoPut.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;
    private boolean _lazyFolderCreationOnPut;
    private String _userAgent;

    public DoPut(IWebdavStore store, IResourceLocks resLocks, boolean readOnly, boolean lazyFolderCreationOnPut) {
        this._store = store;
        this._resourceLocks = resLocks;
        this._readOnly = readOnly;
        this._lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        block26: {
            block23: {
                block24: {
                    DoPut.LOG.trace("-- " + this.getClass().getName());
                    if (this._readOnly) break block23;
                    path = this.getRelativePath(req);
                    parentPath = this.getParentPath(path);
                    this._userAgent = req.getHeader("User-Agent");
                    errorList = new Hashtable<String, Integer>();
                    if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                        errorList.put(parentPath, 423);
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    if (!this.checkLocks(transaction, req, resp, this._resourceLocks, path)) {
                        errorList.put(path, 423);
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    tempLockOwner = "doPut" + System.currentTimeMillis() + req.toString();
                    if (!this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) break block24;
                    so = null;
                    try {
                        block25: {
                            parentSo = this._store.getStoredObject(transaction, parentPath);
                            if (parentPath != null && parentSo != null && parentSo.isResource()) {
                                resp.sendError(403);
                                return;
                            }
                            if (parentPath != null && parentSo == null && this._lazyFolderCreationOnPut) {
                                this._store.createFolder(transaction, parentPath);
                            } else if (parentPath != null && parentSo == null && !this._lazyFolderCreationOnPut) {
                                errorList.put(parentPath, 404);
                                this.sendReport(req, resp, errorList);
                                return;
                            }
                            so = this._store.getStoredObject(transaction, path);
                            if (so != null) break block25;
                            this._store.createResource(transaction, path);
                            ** GOTO lbl64
                        }
                        if (!so.isNullResource()) ** GOTO lbl64
                        nullResourceLo = this._resourceLocks.getLockedObjectByPath(transaction, path);
                        if (nullResourceLo == null) {
                            resp.sendError(500);
                            return;
                        }
                        nullResourceLockToken = nullResourceLo.getID();
                        lockTokens = this.getLockIdFromIfHeader(req);
                        lockToken = null;
                        if (lockTokens == null) {
                            resp.sendError(400);
                            return;
                        }
                        lockToken = lockTokens[0];
                        try {
                            if (lockToken.equals(nullResourceLockToken)) {
                                so.setNullResource(false);
                                so.setFolder(false);
                                nullResourceLockOwners = nullResourceLo.getOwner();
                                owner = null;
                                if (nullResourceLockOwners != null) {
                                    owner = nullResourceLockOwners[0];
                                }
                                if (!this._resourceLocks.unlock(transaction, lockToken, owner)) {
                                    resp.sendError(500);
                                }
                            } else {
                                errorList.put(path, 423);
                                this.sendReport(req, resp, errorList);
                            }
lbl64:
                            // 4 sources

                            this.doUserAgentWorkaround(resp);
                            resourceLength = this._store.setResourceContent(transaction, path, (InputStream)req.getInputStream(), null, null);
                            so = this._store.getStoredObject(transaction, path);
                            if (resourceLength == -1L) ** GOTO lbl84
                            so.setResourceLength(resourceLength);
                        }
                        catch (AccessDeniedException e) {
                            resp.sendError(403);
                        }
                        catch (WebdavException e) {
                            resp.sendError(500);
                        }
                    }
                    finally {
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                    }
                }
                resp.sendError(500);
                break block26;
            }
            resp.sendError(403);
        }
    }

    private void doUserAgentWorkaround(HttpServletResponse resp) {
        if (this._userAgent != null && this._userAgent.indexOf("WebDAVFS") != -1 && this._userAgent.indexOf("Transmit") == -1) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this._userAgent + "'");
            resp.setStatus(201);
        } else if (this._userAgent != null && this._userAgent.indexOf("Transmit") != -1) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this._userAgent + "'");
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
    }
}

