/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.DeterminableMethod;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoOptions
extends DeterminableMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoOptions.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;

    public DoOptions(IWebdavStore store, IResourceLocks resLocks) {
        this._store = store;
        this._resourceLocks = resLocks;
    }

    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        String tempLockOwner = "doOptions" + System.currentTimeMillis() + req.toString();
        String path = this.getRelativePath(req);
        if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
            StoredObject so = null;
            try {
                try {
                    resp.addHeader("DAV", "1, 2");
                    so = this._store.getStoredObject(transaction, path);
                    String methodsAllowed = DoOptions.determineMethodsAllowed(so);
                    resp.addHeader("Allow", methodsAllowed);
                    resp.addHeader("MS-Author-Via", "DAV");
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }
}

