/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.ObjectAlreadyExistsException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.AbstractMethod;
import com.ejie.x38.webdav.methods.DoCopy;
import com.ejie.x38.webdav.methods.DoDelete;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMove
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoMove.class);
    private IResourceLocks _resourceLocks;
    private DoDelete _doDelete;
    private DoCopy _doCopy;
    private boolean _readOnly;

    public DoMove(IResourceLocks resourceLocks, DoDelete doDelete, DoCopy doCopy, boolean readOnly) {
        this._resourceLocks = resourceLocks;
        this._doDelete = doDelete;
        this._doCopy = doCopy;
        this._readOnly = readOnly;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        if (!this._readOnly) {
            LOG.trace("-- " + this.getClass().getName());
            String sourcePath = this.getRelativePath(req);
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, sourcePath)) {
                errorList.put(sourcePath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            String destinationPath = req.getHeader("Destination");
            if (destinationPath == null) {
                resp.sendError(400);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, destinationPath)) {
                errorList.put(destinationPath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            String tempLockOwner = "doMove" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, sourcePath, tempLockOwner, false, 0, 10, true)) {
                try {
                    try {
                        if (!this._doCopy.copyResource(transaction, req, resp)) return;
                        errorList = new Hashtable();
                        this._doDelete.deleteResource(transaction, sourcePath, errorList, req, resp);
                        if (errorList.isEmpty()) return;
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    catch (AccessDeniedException e) {
                        resp.sendError(403);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                        return;
                    }
                    catch (ObjectAlreadyExistsException e) {
                        resp.sendError(404, req.getRequestURI());
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                        return;
                    }
                    catch (WebdavException e) {
                        resp.sendError(500);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                }
            } else {
                errorList.put(req.getHeader("Destination"), 423);
                this.sendReport(req, resp, errorList);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }
}

