/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.AbstractMethod;
import com.ejie.x38.webdav.methods.DeterminableMethod;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoMkcol
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoMkcol.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoMkcol(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        block21: {
            block19: {
                block20: {
                    DoMkcol.LOG.trace("-- " + this.getClass().getName());
                    if (this._readOnly) break block19;
                    path = this.getRelativePath(req);
                    parentPath = this.getParentPath(this.getCleanPath(path));
                    errorList = new Hashtable<String, Integer>();
                    if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                        DoMkcol.LOG.trace("MkCol on locked resource (parentPath) not executable!\n Sending SC_FORBIDDEN (403) error response!");
                        resp.sendError(403);
                        return;
                    }
                    tempLockOwner = "doMkcol" + System.currentTimeMillis() + req.toString();
                    if (!this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) break block20;
                    so = null;
                    try {
                        parentSo = this._store.getStoredObject(transaction, parentPath);
                        if (parentSo == null) {
                            resp.sendError(409);
                            return;
                        }
                        if (parentPath == null || !parentSo.isFolder()) ** GOTO lbl58
                        so = this._store.getStoredObject(transaction, path);
                        if (so == null) {
                            this._store.createFolder(transaction, path);
                            resp.setStatus(201);
                        }
                        if (!so.isNullResource()) ** GOTO lbl54
                        nullResourceLo = this._resourceLocks.getLockedObjectByPath(transaction, path);
                        if (nullResourceLo == null) {
                            resp.sendError(500);
                            return;
                        }
                        nullResourceLockToken = nullResourceLo.getID();
                        lockTokens = this.getLockIdFromIfHeader(req);
                        lockToken = null;
                        if (lockTokens == null) {
                            resp.sendError(400);
                            return;
                        }
                        lockToken = lockTokens[0];
                        try {
                            if (lockToken.equals(nullResourceLockToken)) {
                                so.setNullResource(false);
                                so.setFolder(true);
                                nullResourceLockOwners = nullResourceLo.getOwner();
                                owner = null;
                                if (nullResourceLockOwners != null) {
                                    owner = nullResourceLockOwners[0];
                                }
                                if (this._resourceLocks.unlock(transaction, lockToken, owner)) {
                                    resp.setStatus(201);
                                }
                                resp.sendError(500);
                            }
                            DoMkcol.LOG.trace("MkCol on lock-null-resource with wrong lock-token!\n Sending multistatus error report!");
                            errorList.put(path, 423);
                            this.sendReport(req, resp, errorList);
lbl54:
                            // 1 sources

                            methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                            resp.addHeader("Allow", methodsAllowed);
                            resp.sendError(405);
lbl58:
                            // 1 sources

                            if (parentPath != null && parentSo.isResource()) {
                                DoMkcol.LOG.trace("MkCol on resource is not executable\n Sending SC_METHOD_NOT_ALLOWED (405) error response!");
                                methodsAllowed = DeterminableMethod.determineMethodsAllowed(parentSo);
                                resp.addHeader("Allow", methodsAllowed);
                                resp.sendError(405);
                            }
                            resp.sendError(403);
                        }
                        catch (AccessDeniedException e) {
                            resp.sendError(403);
                        }
                        catch (WebdavException e) {
                            resp.sendError(500);
                        }
                    }
                    finally {
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                    }
                }
                resp.sendError(500);
                break block21;
            }
            resp.sendError(403);
        }
    }
}

