/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.fromcatalina.XMLWriter;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.locking.LockedObject;
import com.ejie.x38.webdav.methods.AbstractMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DoLock
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoLock.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;
    private boolean _macLockRequest = false;
    private boolean _exclusive = false;
    private String _type = null;
    private String _lockOwner = null;
    private String _path = null;
    private String _parentPath = null;
    private String _userAgent = null;

    public DoLock(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        block11: {
            String tempLockOwner;
            LOG.trace("-- " + this.getClass().getName());
            if (this._readOnly) {
                resp.sendError(403);
                return;
            }
            this._path = this.getRelativePath(req);
            this._parentPath = this.getParentPath(this.getCleanPath(this._path));
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, this._path)) {
                errorList.put(this._path, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, this._parentPath)) {
                errorList.put(this._parentPath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            this._userAgent = req.getHeader("User-Agent");
            if (this._userAgent != null && this._userAgent.indexOf("Darwin") != -1) {
                this._macLockRequest = true;
                String timeString = new Long(System.currentTimeMillis()).toString();
                this._lockOwner = this._userAgent.concat(timeString);
            }
            if (this._resourceLocks.lock(transaction, this._path, tempLockOwner = "doLock" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
                try {
                    try {
                        if (req.getHeader("If") != null) {
                            this.doRefreshLock(transaction, req, resp);
                            break block11;
                        }
                        this.doLock(transaction, req, resp);
                    }
                    catch (LockFailedException e) {
                        resp.sendError(423);
                        e.printStackTrace();
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, this._path, tempLockOwner);
                    }
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, this._path, tempLockOwner);
                }
            }
        }
    }

    private void doLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        StoredObject so = this._store.getStoredObject(transaction, this._path);
        if (so != null) {
            this.doLocking(transaction, req, resp);
        } else {
            this.doNullResourceLock(transaction, req, resp);
        }
        so = null;
        this._exclusive = false;
        this._type = null;
        this._lockOwner = null;
    }

    private void doLocking(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LockedObject<? extends IResourceLocks> lo = this._resourceLocks.getLockedObjectByPath(transaction, this._path);
        if (lo != null && lo.isExclusive()) {
            this.sendLockFailError(transaction, req, resp);
            return;
        }
        try {
            try {
                this.executeLock(transaction, req, resp);
            }
            catch (ServletException e) {
                resp.sendError(500);
                LOG.trace(e.toString());
                lo = null;
            }
            catch (LockFailedException e) {
                this.sendLockFailError(transaction, req, resp);
                lo = null;
            }
        }
        finally {
            lo = null;
        }
    }

    private void doNullResourceLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StoredObject parentSo;
        StoredObject nullSo = null;
        try {
            parentSo = this._store.getStoredObject(transaction, this._parentPath);
            if (this._parentPath != null && parentSo == null) {
                this._store.createFolder(transaction, this._parentPath);
            } else if (this._parentPath != null && parentSo != null && parentSo.isResource()) {
                resp.sendError(412);
                return;
            }
            nullSo = this._store.getStoredObject(transaction, this._path);
            if (nullSo == null) {
                this._store.createResource(transaction, this._path);
                if (this._userAgent != null && this._userAgent.indexOf("Transmit") != -1) {
                    LOG.trace("DoLock.execute() : do workaround for user agent '" + this._userAgent + "'");
                    resp.setStatus(204);
                } else {
                    resp.setStatus(201);
                }
            } else {
                this.sendLockFailError(transaction, req, resp);
                return;
            }
            try {
                nullSo = this._store.getStoredObject(transaction, this._path);
                nullSo.setNullResource(true);
                this.executeLock(transaction, req, resp);
            }
            catch (LockFailedException e) {
                this.sendLockFailError(transaction, req, resp);
            }
            catch (WebdavException e) {
                resp.sendError(500);
                e.printStackTrace();
            }
            catch (ServletException e) {
                resp.sendError(500);
                e.printStackTrace();
            }
        }
        finally {
            parentSo = null;
            nullSo = null;
        }
    }

    private void doRefreshLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        String[] lockTokens = this.getLockIdFromIfHeader(req);
        String lockToken = null;
        if (lockTokens != null) {
            lockToken = lockTokens[0];
        }
        if (lockToken != null) {
            LockedObject<? extends IResourceLocks> refreshLo = this._resourceLocks.getLockedObjectByID(transaction, lockToken);
            if (refreshLo != null) {
                int timeout = this.getTimeout(transaction, req);
                refreshLo.refreshTimeout(timeout);
                this.generateXMLReport(transaction, resp, refreshLo);
                refreshLo = null;
            } else {
                resp.sendError(412);
            }
        } else {
            resp.sendError(412);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeLock(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws LockFailedException, IOException, ServletException {
        if (this._macLockRequest) {
            LOG.trace("DoLock.execute() : do workaround for user agent '" + this._userAgent + "'");
            this.doMacLockRequestWorkaround(transaction, req, resp);
            return;
        }
        if (!this.getLockInformation(transaction, req, resp)) {
            resp.setContentType("text/xml; charset=UTF-8");
            resp.sendError(400);
            return;
        }
        int depth = this.getDepth(req);
        int lockDuration = this.getTimeout(transaction, req);
        boolean lockSuccess = false;
        lockSuccess = this._exclusive ? this._resourceLocks.exclusiveLock(transaction, this._path, this._lockOwner, depth, lockDuration) : this._resourceLocks.sharedLock(transaction, this._path, this._lockOwner, depth, lockDuration);
        if (!lockSuccess) {
            this.sendLockFailError(transaction, req, resp);
            throw new LockFailedException();
        }
        LockedObject<? extends IResourceLocks> lo = this._resourceLocks.getLockedObjectByPath(transaction, this._path);
        if (lo != null) {
            this.generateXMLReport(transaction, resp, lo);
            return;
        }
        resp.sendError(500);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getLockInformation(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Element lockInfoNode = null;
        DocumentBuilder documentBuilder = null;
        documentBuilder = this.getDocumentBuilder();
        try {
            Element rootElement;
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            lockInfoNode = rootElement = document.getDocumentElement();
            if (lockInfoNode == null) return false;
            NodeList childList = lockInfoNode.getChildNodes();
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            Node currentNode = null;
            String nodeName = null;
            int i = 0;
            while (i < childList.getLength()) {
                currentNode = childList.item(i);
                if (currentNode.getNodeType() != 1) {
                    if (currentNode.getNodeType() != 3) return false;
                }
                if ((nodeName = currentNode.getNodeName()).endsWith("locktype")) {
                    lockTypeNode = currentNode;
                }
                if (nodeName.endsWith("lockscope")) {
                    lockScopeNode = currentNode;
                }
                if (nodeName.endsWith("owner")) {
                    lockOwnerNode = currentNode;
                }
                ++i;
            }
            if (lockScopeNode == null) return false;
            String scope = null;
            childList = lockScopeNode.getChildNodes();
            int i2 = 0;
            while (i2 < childList.getLength()) {
                currentNode = childList.item(i2);
                if (currentNode.getNodeType() == 1) {
                    scope = currentNode.getNodeName();
                    if (scope.endsWith("exclusive")) {
                        this._exclusive = true;
                    } else if (scope.equals("shared")) {
                        this._exclusive = false;
                    }
                }
                ++i2;
            }
            if (scope == null) {
                return false;
            }
            if (lockTypeNode == null) return false;
            childList = lockTypeNode.getChildNodes();
            i = 0;
            while (i < childList.getLength()) {
                currentNode = childList.item(i);
                if (currentNode.getNodeType() == 1) {
                    this._type = currentNode.getNodeName();
                    if (this._type.endsWith("write")) {
                        this._type = "write";
                    } else if (this._type.equals("read")) {
                        this._type = "read";
                    }
                }
                ++i;
            }
            if (this._type == null) {
                return false;
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                i = 0;
                while (i < childList.getLength()) {
                    currentNode = childList.item(i);
                    if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 3) {
                        this._lockOwner = currentNode.getTextContent();
                    }
                    ++i;
                }
            }
            if (this._lockOwner != null) return true;
            return false;
        }
        catch (DOMException e) {
            resp.sendError(500);
            e.printStackTrace();
            return false;
        }
        catch (SAXException e) {
            resp.sendError(500);
            e.printStackTrace();
            return false;
        }
    }

    private int getTimeout(ITransaction transaction, HttpServletRequest req) {
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(44);
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = new Integer(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration <= 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        return lockDuration;
    }

    private void generateXMLReport(ITransaction transaction, HttpServletResponse resp, LockedObject lo) throws IOException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("DAV:", "D");
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter(), namespaces);
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("DAV::prop", 0);
        generatedXML.writeElement("DAV::lockdiscovery", 0);
        generatedXML.writeElement("DAV::activelock", 0);
        generatedXML.writeElement("DAV::locktype", 0);
        generatedXML.writeProperty("DAV::" + this._type);
        generatedXML.writeElement("DAV::locktype", 1);
        generatedXML.writeElement("DAV::lockscope", 0);
        if (this._exclusive) {
            generatedXML.writeProperty("DAV::exclusive");
        } else {
            generatedXML.writeProperty("DAV::shared");
        }
        generatedXML.writeElement("DAV::lockscope", 1);
        int depth = lo.getLockDepth();
        generatedXML.writeElement("DAV::depth", 0);
        if (depth == 3) {
            generatedXML.writeText("Infinity");
        } else {
            generatedXML.writeText(String.valueOf(depth));
        }
        generatedXML.writeElement("DAV::depth", 1);
        generatedXML.writeElement("DAV::owner", 0);
        generatedXML.writeText(this._lockOwner);
        generatedXML.writeElement("DAV::owner", 1);
        long timeout = lo.getTimeoutMillis();
        generatedXML.writeElement("DAV::timeout", 0);
        generatedXML.writeText("Second-" + timeout / 1000L);
        generatedXML.writeElement("DAV::timeout", 1);
        String lockToken = lo.getID();
        generatedXML.writeElement("DAV::locktoken", 0);
        generatedXML.writeElement("DAV::href", 0);
        generatedXML.writeText("opaquelocktoken:" + lockToken);
        generatedXML.writeElement("DAV::href", 1);
        generatedXML.writeElement("DAV::locktoken", 1);
        generatedXML.writeElement("DAV::activelock", 1);
        generatedXML.writeElement("DAV::lockdiscovery", 1);
        generatedXML.writeElement("DAV::prop", 1);
        resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        generatedXML.sendData();
    }

    private void doMacLockRequestWorkaround(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws LockFailedException, IOException {
        int depth = this.getDepth(req);
        int lockDuration = this.getTimeout(transaction, req);
        if (lockDuration < 0 || lockDuration > 604800) {
            lockDuration = 3600;
        }
        boolean lockSuccess = false;
        lockSuccess = this._resourceLocks.exclusiveLock(transaction, this._path, this._lockOwner, depth, lockDuration);
        if (lockSuccess) {
            LockedObject<? extends IResourceLocks> lo = this._resourceLocks.getLockedObjectByPath(transaction, this._path);
            if (lo != null) {
                this.generateXMLReport(transaction, resp, lo);
            } else {
                resp.sendError(500);
            }
        } else {
            this.sendLockFailError(transaction, req, resp);
        }
    }

    private void sendLockFailError(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        errorList.put(this._path, 423);
        this.sendReport(req, resp, errorList);
    }
}

