/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.IMimeTyper;
import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.ObjectAlreadyExistsException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.AbstractMethod;
import com.ejie.x38.webdav.methods.DeterminableMethod;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoHead
extends AbstractMethod {
    protected String _dftIndexFile;
    protected IWebdavStore _store;
    protected String _insteadOf404;
    protected IResourceLocks _resourceLocks;
    protected IMimeTyper _mimeTyper;
    protected int _contentLength;
    private static Logger LOG = LoggerFactory.getLogger(DoHead.class);

    public DoHead(IWebdavStore store, String dftIndexFile, String insteadOf404, IResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        this._store = store;
        this._dftIndexFile = dftIndexFile;
        this._insteadOf404 = insteadOf404;
        this._resourceLocks = resourceLocks;
        this._mimeTyper = mimeTyper;
        this._contentLength = contentLengthHeader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        block27: {
            block29: {
                block30: {
                    block28: {
                        bUriExists = false;
                        path = this.getRelativePath(req);
                        DoHead.LOG.trace("-- " + this.getClass().getName());
                        so = this._store.getStoredObject(transaction, path);
                        if (so == null) {
                            if (this._insteadOf404 != null && !this._insteadOf404.trim().equals("")) {
                                path = this._insteadOf404;
                                so = this._store.getStoredObject(transaction, this._insteadOf404);
                            }
                        } else {
                            bUriExists = true;
                        }
                        if (so == null) break block29;
                        if (so.isFolder()) {
                            if (this._dftIndexFile != null && !this._dftIndexFile.trim().equals("")) {
                                resp.sendRedirect(resp.encodeRedirectURL(String.valueOf(req.getRequestURI()) + this._dftIndexFile));
                                return;
                            }
                        } else if (so.isNullResource()) {
                            methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                            resp.addHeader("Allow", methodsAllowed);
                            resp.sendError(405);
                            return;
                        }
                        if (!this._resourceLocks.lock(transaction, path, tempLockOwner = "doGet" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) break block30;
                        try {
                            eTagMatch = req.getHeader("If-None-Match");
                            if (eTagMatch != null && eTagMatch.equals(this.getETag(so))) {
                                resp.setStatus(304);
                            }
                            ** GOTO lbl-1000
                        }
                        catch (AccessDeniedException e) {
                            resp.sendError(403);
                            this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                            break block27;
                        }
                        catch (ObjectAlreadyExistsException e) {
                            resp.sendError(404, req.getRequestURI());
                            break block27;
                            catch (WebdavException e) {
                                resp.sendError(500);
                                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                                break block27;
                            }
                            finally {
                                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                            }
                        }
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            if (so.isResource()) {
                                if (path.endsWith("/") || path.endsWith("\\")) {
                                    resp.sendError(404, req.getRequestURI());
                                    break block28;
                                } else {
                                    lastModified = so.getLastModified().getTime();
                                    resp.setDateHeader("last-modified", lastModified);
                                    eTag = this.getETag(so);
                                    resp.addHeader("ETag", eTag);
                                    resourceLength = so.getResourceLength();
                                    if (this._contentLength == 1 && resourceLength > 0L) {
                                        if (resourceLength <= 0x7FFFFFFFL) {
                                            resp.setContentLength((int)resourceLength);
                                        } else {
                                            resp.setHeader("content-length", "" + resourceLength);
                                        }
                                    }
                                    if ((mimeType = this._mimeTyper != null ? this._mimeTyper.getMimeType(path) : req.getSession().getServletContext().getMimeType(path)) != null) {
                                        resp.setContentType(mimeType);
                                    } else {
                                        lastSlash = path.replace('\\', '/').lastIndexOf(47);
                                        lastDot = path.indexOf(".", lastSlash);
                                        if (lastDot == -1) {
                                            resp.setContentType("text/html");
                                        }
                                    }
                                    this.doBody(transaction, resp, path);
                                }
                                break block28;
                            }
                            this.folderBody(transaction, path, resp, req);
                        }
                    }
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                    break block27;
                }
                resp.sendError(500);
                break block27;
            }
            this.folderBody(transaction, path, resp, req);
        }
        if (bUriExists != false) return;
        resp.setStatus(404);
    }

    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
    }

    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) throws IOException {
    }
}

