/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.IMimeTyper;
import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.DeterminableMethod;
import com.ejie.x38.webdav.methods.DoHead;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoGet
extends DoHead {
    private static Logger LOG = LoggerFactory.getLogger(DoGet.class);

    public DoGet(IWebdavStore store, String dftIndexFile, String insteadOf404, IResourceLocks resourceLocks, IMimeTyper mimeTyper, int contentLengthHeader) {
        super(store, dftIndexFile, insteadOf404, resourceLocks, mimeTyper, contentLengthHeader);
    }

    @Override
    protected void doBody(ITransaction transaction, HttpServletResponse resp, String path) {
        try {
            StoredObject so = this._store.getStoredObject(transaction, path);
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            ServletOutputStream out = resp.getOutputStream();
            InputStream in = this._store.getResourceContent(transaction, path);
            try {
                int read = -1;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    out.write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOG.warn("Closing InputStream causes Exception!\n" + e.toString());
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    LOG.warn("Flushing OutputStream causes Exception!\n" + e.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.trace(e.toString());
        }
    }

    @Override
    protected void folderBody(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) throws IOException {
        StoredObject so = this._store.getStoredObject(transaction, path);
        if (so == null) {
            resp.sendError(404, req.getRequestURI());
        } else {
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            if (so.isFolder()) {
                DateFormat shortDF = this.getDateTimeFormat(req.getLocale());
                resp.setContentType("text/html");
                resp.setCharacterEncoding("UTF8");
                ServletOutputStream out = resp.getOutputStream();
                String[] children = this._store.getChildrenNames(transaction, path);
                children = children == null ? new String[]{} : children;
                StringBuilder childrenTemp = new StringBuilder();
                childrenTemp.append("<html><head><title>Content of folder");
                childrenTemp.append(path);
                childrenTemp.append("</title><style type=\"text/css\">");
                childrenTemp.append(this.getCSS());
                childrenTemp.append("</style></head>");
                childrenTemp.append("<body>");
                childrenTemp.append(this.getHeader(transaction, path, resp, req));
                childrenTemp.append("<table>");
                childrenTemp.append("<tr><th>Name</th><th>Size</th><th>Created</th><th>Modified</th></tr>");
                childrenTemp.append("<tr>");
                childrenTemp.append("<td colspan=\"4\"><a href=\"../\">Parent</a></td></tr>");
                boolean isEven = false;
                String[] stringArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    String child = stringArray[n2];
                    isEven = !isEven;
                    childrenTemp.append("<tr class=\"");
                    childrenTemp.append(isEven ? "even" : "odd");
                    childrenTemp.append("\">");
                    childrenTemp.append("<td>");
                    childrenTemp.append("<a href=\"");
                    childrenTemp.append(child);
                    StoredObject obj = this._store.getStoredObject(transaction, String.valueOf(path) + "/" + child);
                    if (obj.isFolder()) {
                        childrenTemp.append("/");
                    }
                    childrenTemp.append("\">");
                    childrenTemp.append(child);
                    childrenTemp.append("</a></td>");
                    if (obj.isFolder()) {
                        childrenTemp.append("<td>Folder</td>");
                    } else {
                        childrenTemp.append("<td>");
                        childrenTemp.append(obj.getResourceLength());
                        childrenTemp.append(" Bytes</td>");
                    }
                    if (obj.getCreationDate() != null) {
                        childrenTemp.append("<td>");
                        childrenTemp.append(shortDF.format(obj.getCreationDate()));
                        childrenTemp.append("</td>");
                    } else {
                        childrenTemp.append("<td></td>");
                    }
                    if (obj.getLastModified() != null) {
                        childrenTemp.append("<td>");
                        childrenTemp.append(shortDF.format(obj.getLastModified()));
                        childrenTemp.append("</td>");
                    } else {
                        childrenTemp.append("<td></td>");
                    }
                    childrenTemp.append("</tr>");
                    ++n2;
                }
                childrenTemp.append("</table>");
                childrenTemp.append(this.getFooter(transaction, path, resp, req));
                childrenTemp.append("</body></html>");
                out.write(childrenTemp.toString().getBytes("UTF-8"));
            }
        }
    }

    protected String getCSS() {
        String retVal = "body {\n\tfont-family: Arial, Helvetica, sans-serif;\n}\nh1 {\n\tfont-size: 1.5em;\n}\nth {\n\tbackground-color: #9DACBF;\n}\ntable {\n\tborder-top-style: solid;\n\tborder-right-style: solid;\n\tborder-bottom-style: solid;\n\tborder-left-style: solid;\n}\ntd {\n\tmargin: 0px;\n\tpadding-top: 2px;\n\tpadding-right: 5px;\n\tpadding-bottom: 2px;\n\tpadding-left: 5px;\n}\ntr.even {\n\tbackground-color: #CCCCCC;\n}\ntr.odd {\n\tbackground-color: #FFFFFF;\n}\n";
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream iStream = cl.getResourceAsStream("webdav.css");
            if (iStream != null) {
                int n;
                StringBuilder out = new StringBuilder();
                byte[] b = new byte[4096];
                while ((n = iStream.read(b)) != -1) {
                    out.append(new String(b, 0, n));
                }
                retVal = out.toString();
            }
        }
        catch (Exception ex) {
            LOG.error("Error in reading webdav.css", (Throwable)ex);
        }
        return retVal;
    }

    protected DateFormat getDateTimeFormat(Locale browserLocale) {
        return SimpleDateFormat.getDateTimeInstance(3, 2, browserLocale);
    }

    protected String getHeader(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) {
        return "<h1>Content of folder " + path + "</h1>";
    }

    protected String getFooter(ITransaction transaction, String path, HttpServletResponse resp, HttpServletRequest req) {
        return "";
    }
}

