/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.AccessDeniedException;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.exceptions.ObjectAlreadyExistsException;
import com.ejie.x38.webdav.exceptions.ObjectNotFoundException;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.methods.AbstractMethod;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoDelete
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoDelete.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoDelete(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (!this._readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(this.getCleanPath(path));
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                errorList.put(parentPath, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, path)) {
                errorList.put(path, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            String tempLockOwner = "doDelete" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                try {
                    try {
                        errorList = new Hashtable();
                        this.deleteResource(transaction, path, errorList, req, resp);
                        if (errorList.isEmpty()) return;
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    catch (AccessDeniedException e) {
                        resp.sendError(403);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                    }
                    catch (ObjectAlreadyExistsException e) {
                        resp.sendError(404, req.getRequestURI());
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                    }
                    catch (WebdavException e) {
                        resp.sendError(500);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    public void deleteResource(ITransaction transaction, String path, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws IOException, WebdavException {
        resp.setStatus(204);
        if (!this._readOnly) {
            StoredObject so = this._store.getStoredObject(transaction, path);
            if (so != null) {
                if (so.isResource()) {
                    this._store.removeObject(transaction, path);
                } else if (so.isFolder()) {
                    this.deleteFolder(transaction, path, errorList, req, resp);
                    this._store.removeObject(transaction, path);
                } else {
                    resp.sendError(404);
                }
            } else {
                resp.sendError(404);
            }
            so = null;
        } else {
            resp.sendError(403);
        }
    }

    private void deleteFolder(ITransaction transaction, String path, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        String[] children = this._store.getChildrenNames(transaction, path);
        children = children == null ? new String[]{} : children;
        StoredObject so = null;
        int i = children.length - 1;
        while (i >= 0) {
            children[i] = "/" + children[i];
            try {
                so = this._store.getStoredObject(transaction, String.valueOf(path) + children[i]);
                if (so.isResource()) {
                    this._store.removeObject(transaction, String.valueOf(path) + children[i]);
                } else {
                    this.deleteFolder(transaction, String.valueOf(path) + children[i], errorList, req, resp);
                    this._store.removeObject(transaction, String.valueOf(path) + children[i]);
                }
            }
            catch (AccessDeniedException e) {
                errorList.put(String.valueOf(path) + children[i], new Integer(403));
            }
            catch (ObjectNotFoundException e) {
                errorList.put(String.valueOf(path) + children[i], new Integer(404));
            }
            catch (WebdavException e) {
                errorList.put(String.valueOf(path) + children[i], new Integer(500));
            }
            --i;
        }
        so = null;
    }
}

