/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.methods;

import com.ejie.x38.webdav.IMethodExecutor;
import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.WebdavStatus;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.fromcatalina.URLEncoder;
import com.ejie.x38.webdav.fromcatalina.XMLWriter;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.locking.LockedObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public abstract class AbstractMethod
implements IMethodExecutor {
    protected static URLEncoder URL_ENCODER;
    protected static final int INFINITY = 3;
    protected static final SimpleDateFormat CREATION_DATE_FORMAT;
    protected static final SimpleDateFormat LAST_MODIFIED_DATE_FORMAT;
    protected static int BUF_SIZE;
    protected static final int DEFAULT_TIMEOUT = 3600;
    protected static final int MAX_TIMEOUT = 604800;
    protected static final boolean TEMPORARY = true;
    protected static final int TEMP_TIMEOUT = 10;

    static {
        CREATION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        LAST_MODIFIED_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        CREATION_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        LAST_MODIFIED_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        URL_ENCODER = new URLEncoder();
        URL_ENCODER.addSafeCharacter('-');
        URL_ENCODER.addSafeCharacter('_');
        URL_ENCODER.addSafeCharacter('.');
        URL_ENCODER.addSafeCharacter('*');
        URL_ENCODER.addSafeCharacter('/');
        BUF_SIZE = 65536;
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    protected String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    protected String getCleanPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("jaxp failed");
        }
        return documentBuilder;
    }

    protected int getDepth(HttpServletRequest req) {
        int depth = 3;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null) {
            if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            }
        }
        return depth;
    }

    protected String rewriteUrl(String path) {
        return URL_ENCODER.encode(path);
    }

    protected String getETag(StoredObject so) {
        String resourceLength = "";
        String lastModified = "";
        if (so != null && so.isResource()) {
            resourceLength = new Long(so.getResourceLength()).toString();
            lastModified = new Long(so.getLastModified().getTime()).toString();
        }
        return "W/\"" + resourceLength + "-" + lastModified + "\"";
    }

    protected String[] getLockIdFromIfHeader(HttpServletRequest req) {
        String[] ids = new String[2];
        String id = req.getHeader("If");
        if (id != null && !id.equals("")) {
            if (id.indexOf(">)") == id.lastIndexOf(">)")) {
                if ((id = id.substring(id.indexOf("(<"), id.indexOf(">)"))).indexOf("locktoken:") != -1) {
                    id = id.substring(id.indexOf(58) + 1);
                }
                ids[0] = id;
            } else {
                String firstId = id.substring(id.indexOf("(<"), id.indexOf(">)"));
                if (firstId.indexOf("locktoken:") != -1) {
                    firstId = firstId.substring(firstId.indexOf(58) + 1);
                }
                ids[0] = firstId;
                String secondId = id.substring(id.lastIndexOf("(<"), id.lastIndexOf(">)"));
                if (secondId.indexOf("locktoken:") != -1) {
                    secondId = secondId.substring(secondId.indexOf(58) + 1);
                }
                ids[1] = secondId;
            }
        } else {
            ids = null;
        }
        return ids;
    }

    protected String getLockIdFromLockTokenHeader(HttpServletRequest req) {
        String id = req.getHeader("Lock-Token");
        if (id != null) {
            id = id.substring(id.indexOf(":") + 1, id.indexOf(">"));
        }
        return id;
    }

    protected boolean checkLocks(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp, IResourceLocks resourceLocks, String path) throws IOException, LockFailedException {
        LockedObject<? extends IResourceLocks> loByPath = resourceLocks.getLockedObjectByPath(transaction, path);
        if (loByPath != null) {
            if (loByPath.isShared()) {
                return true;
            }
            String[] lockTokens = this.getLockIdFromIfHeader(req);
            String lockToken = null;
            if (lockTokens == null) {
                return false;
            }
            lockToken = lockTokens[0];
            if (lockToken != null) {
                LockedObject<? extends IResourceLocks> loByIf = resourceLocks.getLockedObjectByID(transaction, lockToken);
                if (loByIf == null) {
                    return false;
                }
                if (!loByIf.equals(loByPath)) {
                    loByIf = null;
                    return false;
                }
                loByIf = null;
            }
        }
        loByPath = null;
        return true;
    }

    protected void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("DAV:", "D");
        XMLWriter generatedXML = new XMLWriter(namespaces);
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("DAV::multistatus", 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            generatedXML.writeElement("DAV::response", 0);
            generatedXML.writeElement("DAV::href", 0);
            String toAppend = null;
            if (absoluteUri.endsWith(errorPath)) {
                toAppend = absoluteUri;
            } else if (absoluteUri.contains(errorPath)) {
                int endIndex = absoluteUri.indexOf(errorPath) + errorPath.length();
                toAppend = absoluteUri.substring(0, endIndex);
            }
            if (!toAppend.startsWith("/") && !toAppend.startsWith("http:")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(errorPath);
            generatedXML.writeElement("DAV::href", 1);
            generatedXML.writeElement("DAV::status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
            generatedXML.writeElement("DAV::status", 1);
            generatedXML.writeElement("DAV::response", 1);
        }
        generatedXML.writeElement("DAV::multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }
}

