/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.locking.LockedObject;
import com.ejie.x38.webdav.locking.MemoryResourceLocks;
import java.util.UUID;

public class MemoryLockedObject
extends LockedObject<MemoryResourceLocks> {
    protected int _lockDepth;
    protected long _expiresAt;
    protected String[] _owner = null;
    protected MemoryLockedObject[] _children = null;
    protected MemoryLockedObject _parent = null;
    protected boolean _exclusive = false;
    protected String _type = null;

    public MemoryLockedObject(MemoryResourceLocks resLocks, String path, boolean temporary) {
        this._path = path;
        this._id = UUID.randomUUID().toString();
        this._resourceLocks = resLocks;
        if (!temporary) {
            ((MemoryResourceLocks)this._resourceLocks).get_locks().put(path, this);
            ((MemoryResourceLocks)this._resourceLocks).get_locksByID().put(this._id, this);
        } else {
            ((MemoryResourceLocks)this._resourceLocks).get_tempLocks().put(path, this);
            ((MemoryResourceLocks)this._resourceLocks).get_tempLocksByID().put(this._id, this);
        }
        ((MemoryResourceLocks)this._resourceLocks).addCleanupCounter();
    }

    @Override
    public boolean addLockedObjectOwner(String owner) {
        if (this._owner == null) {
            this._owner = new String[1];
        } else {
            int size = this._owner.length;
            String[] newLockObjectOwner = new String[size + 1];
            int i = 0;
            while (i < size) {
                if (this._owner[i].equals(owner)) {
                    return false;
                }
                ++i;
            }
            System.arraycopy(this._owner, 0, newLockObjectOwner, 0, size);
            this._owner = newLockObjectOwner;
        }
        this._owner[this._owner.length - 1] = owner;
        return true;
    }

    @Override
    public void removeLockedObjectOwner(String owner) {
        try {
            if (this._owner != null) {
                int size = this._owner.length;
                int i = 0;
                while (i < size) {
                    if (this._owner[i].equals(owner)) {
                        String[] newLockedObjectOwner = new String[size - 1];
                        int j = 0;
                        while (j < size - 1) {
                            newLockedObjectOwner[j] = j < i ? this._owner[j] : this._owner[j + 1];
                            ++j;
                        }
                        this._owner = newLockedObjectOwner;
                    }
                    ++i;
                }
                if (this._owner.length == 0) {
                    this._owner = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("LockedObject.removeLockedObjectOwner()");
            System.out.println(e.toString());
        }
    }

    public void addChild(MemoryLockedObject newChild) {
        if (this._children == null) {
            this._children = new MemoryLockedObject[0];
        }
        int size = this._children.length;
        MemoryLockedObject[] newChildren = new MemoryLockedObject[size + 1];
        System.arraycopy(this._children, 0, newChildren, 0, size);
        newChildren[size] = newChild;
        this._children = newChildren;
    }

    @Override
    public void removeLockedObject() {
        if (this != ((MemoryResourceLocks)this._resourceLocks)._root && !this.getPath().equals("/")) {
            int size = this._parent._children.length;
            int i = 0;
            while (i < size) {
                if (this._parent._children[i].equals(this)) {
                    MemoryLockedObject[] newChildren = new MemoryLockedObject[size - 1];
                    int i2 = 0;
                    while (i2 < size - 1) {
                        newChildren[i2] = i2 < i ? this._parent._children[i2] : this._parent._children[i2 + 1];
                        ++i2;
                    }
                    if (newChildren.length != 0) {
                        this._parent._children = newChildren;
                        break;
                    }
                    this._parent._children = null;
                    break;
                }
                ++i;
            }
            ((MemoryResourceLocks)this._resourceLocks)._locksByID.remove(this.getID());
            ((MemoryResourceLocks)this._resourceLocks)._locks.remove(this.getPath());
        }
    }

    @Override
    public void removeTempLockedObject() {
        if (this != ((MemoryResourceLocks)this._resourceLocks)._tempRoot && this._parent != null && this._parent._children != null) {
            int size = this._parent._children.length;
            int i = 0;
            while (i < size) {
                if (this._parent._children[i].equals(this)) {
                    MemoryLockedObject[] newChildren = new MemoryLockedObject[size - 1];
                    int i2 = 0;
                    while (i2 < size - 1) {
                        newChildren[i2] = i2 < i ? this._parent._children[i2] : this._parent._children[i2 + 1];
                        ++i2;
                    }
                    if (newChildren.length != 0) {
                        this._parent._children = newChildren;
                        break;
                    }
                    this._parent._children = null;
                    break;
                }
                ++i;
            }
            ((MemoryResourceLocks)this._resourceLocks)._tempLocksByID.remove(this.getID());
            ((MemoryResourceLocks)this._resourceLocks)._tempLocks.remove(this.getPath());
        }
    }

    public boolean checkLocks(boolean exclusive, int depth) {
        return this.checkParents(exclusive) && this.checkChildren(exclusive, depth);
    }

    protected boolean checkParents(boolean exclusive) {
        if (this._path.equals("/")) {
            return true;
        }
        if (this._owner == null) {
            return this._parent != null && this._parent.checkParents(exclusive);
        }
        return !this._exclusive && !exclusive && this._parent.checkParents(exclusive);
    }

    protected boolean checkChildren(boolean exclusive, int depth) {
        if (this._children == null) {
            return this._owner == null || !this._exclusive && !exclusive;
        }
        if (this._owner == null) {
            if (depth != 0) {
                boolean canLock = true;
                int limit = this._children.length;
                int i = 0;
                while (i < limit) {
                    if (!this._children[i].checkChildren(exclusive, depth - 1)) {
                        canLock = false;
                    }
                    ++i;
                }
                return canLock;
            }
            return true;
        }
        return !this._exclusive && !exclusive;
    }

    @Override
    public void refreshTimeout(int timeout) {
        this._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    @Override
    public long getTimeoutMillis() {
        return this._expiresAt - System.currentTimeMillis();
    }

    @Override
    public boolean hasExpired() {
        if (this._expiresAt != 0L) {
            return System.currentTimeMillis() > this._expiresAt;
        }
        return true;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String[] getOwner() {
        return this._owner;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public boolean isShared() {
        return !this._exclusive;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public int getLockDepth() {
        return this._lockDepth;
    }
}

