/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.locking.IResourceLocks;

public abstract class LockedObject<T extends IResourceLocks> {
    protected T _resourceLocks;
    protected String _path;
    protected String _id;
    protected int _lockDepth;
    protected long _expiresAt;
    protected String[] _owner = null;
    protected LockedObject<T>[] _children = null;
    protected LockedObject<T> _parent = null;
    protected boolean _exclusive = false;
    protected String _type = null;

    public boolean addLockedObjectOwner(String owner) {
        if (this._owner == null) {
            this._owner = new String[1];
        } else {
            int size = this._owner.length;
            String[] newLockObjectOwner = new String[size + 1];
            int i = 0;
            while (i < size) {
                if (this._owner[i].equals(owner)) {
                    return false;
                }
                ++i;
            }
            System.arraycopy(this._owner, 0, newLockObjectOwner, 0, size);
            this._owner = newLockObjectOwner;
        }
        this._owner[this._owner.length - 1] = owner;
        return true;
    }

    public void removeLockedObjectOwner(String owner) {
        try {
            if (this._owner != null) {
                int size = this._owner.length;
                int i = 0;
                while (i < size) {
                    if (this._owner[i].equals(owner)) {
                        String[] newLockedObjectOwner = new String[size - 1];
                        int j = 0;
                        while (j < size - 1) {
                            newLockedObjectOwner[j] = j < i ? this._owner[j] : this._owner[j + 1];
                            ++j;
                        }
                        this._owner = newLockedObjectOwner;
                    }
                    ++i;
                }
                if (this._owner.length == 0) {
                    this._owner = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("LockedObject.removeLockedObjectOwner()");
            System.out.println(e.toString());
        }
    }

    public abstract void removeLockedObject();

    public abstract void removeTempLockedObject();

    public void refreshTimeout(int timeout) {
        this._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    public long getTimeoutMillis() {
        return this._expiresAt - System.currentTimeMillis();
    }

    public boolean hasExpired() {
        if (this._expiresAt != 0L) {
            return System.currentTimeMillis() > this._expiresAt;
        }
        return true;
    }

    public String getID() {
        return this._id;
    }

    public String[] getOwner() {
        return this._owner;
    }

    public String getPath() {
        return this._path;
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this._exclusive;
    }

    public boolean isShared() {
        return !this._exclusive;
    }

    public String getType() {
        return this._type;
    }

    public int getLockDepth() {
        return this._lockDepth;
    }
}

