/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.exceptions.LockFailedException;
import com.ejie.x38.webdav.locking.DataBaseLockService;
import com.ejie.x38.webdav.locking.DataBaseLockedObject;
import com.ejie.x38.webdav.locking.IResourceLocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component(value="dataBaseResourceLocks")
public class DataBaseResourceLocks
extends SpringBeanAutowiringSupport
implements IResourceLocks {
    private static Logger LOG = LoggerFactory.getLogger(DataBaseResourceLocks.class);
    private boolean _temporary = true;
    protected DataBaseLockService dataBaseLockService;

    @Override
    public synchronized boolean lock(ITransaction transaction, String path, String owner, boolean exclusive, int depth, int timeout, boolean temporary) throws LockFailedException {
        LOG.debug("DataBaseResourceLocks.lock()");
        DataBaseLockedObject lo = null;
        if (temporary) {
            lo = this.generateTempLockedObjects(transaction, path);
            lo._type = "read";
        } else {
            lo = this.generateLockedObjects(transaction, path);
            lo._type = "write";
        }
        if (lo.checkLocks(exclusive, depth)) {
            lo._exclusive = exclusive;
            lo._lockDepth = depth;
            lo._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
            if (lo._parent != null) {
                lo._parent._expiresAt = lo._expiresAt;
            }
            if (lo.addLockedObjectOwner(owner)) {
                this.dataBaseLockService.addLockedObject(lo);
                return true;
            }
            LOG.trace("Couldn't set owner \"" + owner + "\" to resource at '" + path + "'");
            return false;
        }
        LOG.trace("Lock resource at " + path + " failed because" + "\na parent or child resource is currently locked");
        return false;
    }

    @Override
    public synchronized boolean unlock(ITransaction transaction, String id, String owner) {
        LOG.debug("DataBaseResourceLocks.unlock()");
        if (this.dataBaseLockService.isLockedById(id, Boolean.FALSE).booleanValue()) {
            this.dataBaseLockService.unlockObjectById(id, Boolean.FALSE);
        }
        this.checkTimeouts(transaction, Boolean.FALSE);
        return true;
    }

    @Override
    public synchronized void unlockTemporaryLockedObjects(ITransaction transaction, String path, String owner) {
        LOG.debug("DataBaseResourceLocks.unlockTemporaryLockedObjects()");
        if (this.dataBaseLockService.isLockedByPath(path, Boolean.TRUE).booleanValue()) {
            this.dataBaseLockService.unlockObjectByPath(path, Boolean.TRUE);
        }
        this.checkTimeouts(transaction, Boolean.TRUE);
    }

    @Override
    public void checkTimeouts(ITransaction transaction, boolean temporary) {
        LOG.debug("DataBaseResourceLocks.checkTimeouts()");
        this.dataBaseLockService.removeTimeoutLocks(temporary);
    }

    public boolean checkLocks(boolean exclusive, int depth) {
        LOG.debug("DataBaseResourceLocks.checkLocks()");
        return false;
    }

    @Override
    public boolean exclusiveLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        LOG.debug("DataBaseResourceLocks.exclusiveLock()");
        return this.lock(transaction, path, owner, true, depth, timeout, false);
    }

    @Override
    public boolean sharedLock(ITransaction transaction, String path, String owner, int depth, int timeout) throws LockFailedException {
        LOG.debug("DataBaseResourceLocks.sharedLock()");
        return this.lock(transaction, path, owner, false, depth, timeout, false);
    }

    public DataBaseLockedObject getLockedObjectByID(ITransaction transaction, String id) {
        LOG.debug("DataBaseResourceLocks.getLockedObjectByID()");
        DataBaseLockedObject lockedObject = this.dataBaseLockService.getLockedObjectById(id, Boolean.FALSE);
        if (lockedObject != null) {
            return lockedObject;
        }
        return null;
    }

    public DataBaseLockedObject getLockedObjectByPath(ITransaction transaction, String path) {
        LOG.debug("DataBaseResourceLocks.getLockedObjectByPath()");
        DataBaseLockedObject lockedObject = this.dataBaseLockService.getLockedObjectByPath(path, Boolean.FALSE);
        if (lockedObject != null) {
            return lockedObject;
        }
        return null;
    }

    public DataBaseLockedObject getTempLockedObjectByID(ITransaction transaction, String id) {
        LOG.debug("DataBaseResourceLocks.getTempLockedObjectById()");
        DataBaseLockedObject lockedObject = this.dataBaseLockService.getLockedObjectById(id, Boolean.TRUE);
        if (lockedObject != null) {
            return lockedObject;
        }
        return null;
    }

    public DataBaseLockedObject getTempLockedObjectByPath(ITransaction transaction, String path) {
        LOG.debug("DataBaseResourceLocks.getTempLockedObjectByPath()");
        DataBaseLockedObject lockedObject = this.dataBaseLockService.getLockedObjectByPath(path, Boolean.TRUE);
        if (lockedObject != null) {
            return lockedObject;
        }
        return null;
    }

    private DataBaseLockedObject generateLockedObjects(ITransaction transaction, String path) {
        LOG.debug("DataBaseResourceLocks.generateLockedObjects()");
        if (!this.dataBaseLockService.isLockedByPath(path, Boolean.FALSE).booleanValue()) {
            DataBaseLockedObject returnObject = new DataBaseLockedObject(this, path, !this._temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null && !"/".equals(path)) {
                DataBaseLockedObject parentLockedObject = this.generateLockedObjects(transaction, parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject._parent = parentLockedObject;
            }
            return returnObject;
        }
        return this.dataBaseLockService.getLockedObjectByPath(path, Boolean.FALSE);
    }

    private DataBaseLockedObject generateTempLockedObjects(ITransaction transaction, String path) {
        LOG.debug("DataBaseResourceLocks.generateTempLockedObjects()");
        if (!this.dataBaseLockService.isLockedByPath(path, Boolean.TRUE).booleanValue()) {
            DataBaseLockedObject returnObject = new DataBaseLockedObject(this, path, this._temporary);
            String parentPath = this.getParentPath(path);
            if (parentPath != null && !"/".equals(path)) {
                DataBaseLockedObject parentLockedObject = this.generateTempLockedObjects(transaction, parentPath);
                parentLockedObject.addChild(returnObject);
                returnObject._parent = parentLockedObject;
            }
            return returnObject;
        }
        return this.dataBaseLockService.getLockedObjectByPath(path, this._temporary);
    }

    private String getParentPath(String path) {
        LOG.debug("DataBaseResourceLocks.getParentPath()");
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        if (slash == 0) {
            return "/";
        }
        return path.substring(0, slash);
    }

    public void setDataBaseLockService(DataBaseLockService dataBaseLockService) {
        this.dataBaseLockService = dataBaseLockService;
    }
}

