/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.locking.DataBaseModel;
import com.ejie.x38.webdav.locking.DataBaseResourceLocks;
import com.ejie.x38.webdav.locking.LockedObject;
import java.util.List;
import java.util.UUID;

public class DataBaseLockedObject
extends LockedObject<DataBaseResourceLocks> {
    protected DataBaseLockedObject[] _children = null;
    protected DataBaseLockedObject _parent = null;

    public DataBaseLockedObject(DataBaseResourceLocks resLocks, String path, boolean temporary) {
        this._path = path;
        this._id = UUID.randomUUID().toString();
        this._resourceLocks = resLocks;
    }

    public DataBaseLockedObject(List<DataBaseModel> listdataBaseModel) {
        this(listdataBaseModel.get(0));
    }

    public DataBaseLockedObject(DataBaseModel listdataBaseModel) {
        this._id = listdataBaseModel.getId();
        this._path = listdataBaseModel.getPath();
        this._exclusive = listdataBaseModel.getExclusiveLock();
        this._expiresAt = listdataBaseModel.getExpiresAt();
        this._lockDepth = listdataBaseModel.getLockDepth();
        this._owner = new String[]{listdataBaseModel.getOwner()};
        this._type = listdataBaseModel.getLockType();
    }

    @Override
    public boolean addLockedObjectOwner(String owner) {
        if (this._owner == null) {
            this._owner = new String[1];
        } else {
            int size = this._owner.length;
            String[] newLockObjectOwner = new String[size + 1];
            int i = 0;
            while (i < size) {
                if (this._owner[i].equals(owner)) {
                    return false;
                }
                ++i;
            }
            System.arraycopy(this._owner, 0, newLockObjectOwner, 0, size);
            this._owner = newLockObjectOwner;
        }
        this._owner[this._owner.length - 1] = owner;
        return true;
    }

    @Override
    public void removeLockedObjectOwner(String owner) {
        try {
            if (this._owner != null) {
                int size = this._owner.length;
                int i = 0;
                while (i < size) {
                    if (this._owner[i].equals(owner)) {
                        String[] newLockedObjectOwner = new String[size - 1];
                        int j = 0;
                        while (j < size - 1) {
                            newLockedObjectOwner[j] = j < i ? this._owner[j] : this._owner[j + 1];
                            ++j;
                        }
                        this._owner = newLockedObjectOwner;
                    }
                    ++i;
                }
                if (this._owner.length == 0) {
                    this._owner = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("LockedObject.removeLockedObjectOwner()");
            System.out.println(e.toString());
        }
    }

    public void addChild(DataBaseLockedObject newChild) {
        if (this._children == null) {
            this._children = new DataBaseLockedObject[0];
        }
        int size = this._children.length;
        DataBaseLockedObject[] newChildren = new DataBaseLockedObject[size + 1];
        System.arraycopy(this._children, 0, newChildren, 0, size);
        newChildren[size] = newChild;
        this._children = newChildren;
    }

    @Override
    public void removeLockedObject() {
    }

    @Override
    public void removeTempLockedObject() {
    }

    public boolean checkLocks(boolean exclusive, int depth) {
        return this.checkParents(exclusive) && this.checkChildren(exclusive, depth);
    }

    private boolean checkParents(boolean exclusive) {
        if (this._path.equals("/")) {
            return true;
        }
        if (this._owner == null) {
            return this._parent != null && this._parent.checkParents(exclusive);
        }
        return !this._exclusive && !exclusive && this._parent.checkParents(exclusive);
    }

    private boolean checkChildren(boolean exclusive, int depth) {
        if (this._children == null) {
            return this._owner == null || !this._exclusive && !exclusive;
        }
        if (this._owner == null) {
            if (depth != 0) {
                boolean canLock = true;
                int limit = this._children.length;
                int i = 0;
                while (i < limit) {
                    if (!this._children[i].checkChildren(exclusive, depth - 1)) {
                        canLock = false;
                    }
                    ++i;
                }
                return canLock;
            }
            return true;
        }
        return !this._exclusive && !exclusive;
    }

    @Override
    public void refreshTimeout(int timeout) {
        this._expiresAt = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    @Override
    public long getTimeoutMillis() {
        return this._expiresAt - System.currentTimeMillis();
    }

    @Override
    public boolean hasExpired() {
        if (this._expiresAt != 0L) {
            return System.currentTimeMillis() > this._expiresAt;
        }
        return true;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String[] getOwner() {
        return this._owner;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public boolean isShared() {
        return !this._exclusive;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public int getLockDepth() {
        return this._lockDepth;
    }

    public DataBaseModel getDataBaseModel() {
        DataBaseModel dataBaseModel = new DataBaseModel();
        dataBaseModel.setId(this._id);
        dataBaseModel.setPath(this._path);
        dataBaseModel.setExclusiveLock(this._exclusive);
        dataBaseModel.setLockDepth(this._lockDepth);
        dataBaseModel.setExpiresAt(this._expiresAt);
        dataBaseModel.setLockType(this._type);
        if (this._owner != null && this._owner.length > 0) {
            dataBaseModel.setOwner(this._owner[0]);
        }
        if ("read".equals(this._type)) {
            dataBaseModel.setTempLock(Boolean.TRUE);
        } else {
            dataBaseModel.setTempLock(Boolean.FALSE);
        }
        return dataBaseModel;
    }

    public boolean equals(Object obj) {
        DataBaseLockedObject dblo;
        return obj instanceof DataBaseLockedObject && this._id.equals((dblo = (DataBaseLockedObject)obj).getID()) && this._path.equals(dblo.getPath());
    }
}

