/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.locking.DataBaseLockDao;
import com.ejie.x38.webdav.locking.DataBaseLockService;
import com.ejie.x38.webdav.locking.DataBaseLockedObject;
import com.ejie.x38.webdav.locking.DataBaseModel;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="dataBaseLockService")
public class DataBaseLockServiceImpl
implements DataBaseLockService {
    private DataBaseLockDao dataBaseLockDao;

    @Override
    public DataBaseLockedObject getLockedObjectByPath(String path) {
        return this.getLockedObjectByPath(path, Boolean.TRUE);
    }

    @Override
    public DataBaseLockedObject getLockedObjectByPath(String path, Boolean tempLock) {
        List<DataBaseModel> listDataBaseModel = this.dataBaseLockDao.getByPath(path, tempLock);
        if (listDataBaseModel.isEmpty()) {
            return null;
        }
        return new DataBaseLockedObject(listDataBaseModel);
    }

    @Override
    public DataBaseLockedObject getLockedObjectById(String id, Boolean tempLock) {
        List<DataBaseModel> listDataBaseModel = this.dataBaseLockDao.getById(id, tempLock);
        if (listDataBaseModel.isEmpty()) {
            return null;
        }
        return new DataBaseLockedObject(listDataBaseModel);
    }

    @Override
    public Boolean isLockedByPath(String path, Boolean tempLock) {
        return this.dataBaseLockDao.isLockedByPath(path, tempLock);
    }

    @Override
    public Boolean isLockedById(String id, Boolean tempLock) {
        return this.dataBaseLockDao.isLockedById(id, tempLock);
    }

    @Override
    public void addLockedObject(DataBaseLockedObject webdavLockObj) {
        this.dataBaseLockDao.insert(webdavLockObj.getDataBaseModel());
    }

    @Override
    public void unlockObjectById(String id, Boolean tempLock) {
        this.dataBaseLockDao.deleteById(id, tempLock);
    }

    @Override
    public void unlockObjectByPath(String path, Boolean tempLock) {
        this.dataBaseLockDao.deleteByPath(path, tempLock);
    }

    @Override
    public void removeTimeoutLocks(Boolean tempLock) {
        this.dataBaseLockDao.removeTimeoutLocks(tempLock);
    }

    public void setDataBaseLockDao(DataBaseLockDao dataBaseLockDao) {
        this.dataBaseLockDao = dataBaseLockDao;
    }
}

