/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav.locking;

import com.ejie.x38.webdav.locking.DataBaseLockDao;
import com.ejie.x38.webdav.locking.DataBaseModel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class DataBaseLockDaoImpl
implements DataBaseLockDao {
    private Logger logger = LoggerFactory.getLogger(DataBaseLockDaoImpl.class);
    private NamedParameterJdbcTemplate jdbcTemplate;
    private String lockingTableName;
    private RowMapper<DataBaseModel> dataBaseModelRowMapper = new RowMapper<DataBaseModel>(){

        public DataBaseModel mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            DataBaseModel dataBaseModel = new DataBaseModel();
            dataBaseModel.setId(resultSet.getString("ID"));
            dataBaseModel.setOwner(resultSet.getString("OWNER"));
            dataBaseModel.setPath(resultSet.getString("PATH"));
            dataBaseModel.setLockDepth(Integer.valueOf(resultSet.getString("LOCK_DEPTH")));
            dataBaseModel.setExpiresAt(resultSet.getLong("EXPIRES_AT"));
            dataBaseModel.setExclusiveLock(resultSet.getString("EXCLUSIVE_LOCK").equals("0") ? Boolean.FALSE : Boolean.TRUE);
            dataBaseModel.setLockType(resultSet.getString("LOCK_TYPE"));
            dataBaseModel.setChildrenId(resultSet.getString("CHILDREN_ID"));
            dataBaseModel.setParentId(resultSet.getString("PARENT_ID"));
            dataBaseModel.setTempLock(resultSet.getString("TEMP_LOCK").equals("0") ? Boolean.FALSE : Boolean.TRUE);
            return dataBaseModel;
        }
    };

    @Override
    public void insert(DataBaseModel webdavLockObj) {
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(this.lockingTableName).append(" ");
        query.append("(ID, OWNER, PATH, LOCK_DEPTH, EXPIRES_AT, EXCLUSIVE_LOCK, LOCK_TYPE, CHILDREN_ID, PARENT_ID, TEMP_LOCK) ");
        query.append("VALUES (:id, :owner, :path, :lockDepth, :expiresAt, :exclusiveLock, :lockType, :childrenId, :parentId, :tempLock)");
        BeanPropertySqlParameterSource beanParameterSource = new BeanPropertySqlParameterSource((Object)webdavLockObj);
        this.logger.debug("DataBaseLockDaoImpl.insert()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: " + webdavLockObj.toString());
        this.jdbcTemplate.update(query.toString(), (SqlParameterSource)beanParameterSource);
    }

    @Override
    public void delete(DataBaseModel webdavLockObj) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(this.lockingTableName).append(" ");
        query.append("WHERE ID=:id AND OWNER=:owner");
        BeanPropertySqlParameterSource beanParameterSource = new BeanPropertySqlParameterSource((Object)webdavLockObj);
        this.logger.debug("DataBaseLockDaoImpl.delete()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: " + webdavLockObj.toString());
        this.jdbcTemplate.update(query.toString(), (SqlParameterSource)beanParameterSource);
    }

    @Override
    public List<DataBaseModel> getByPath(String path, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ID, OWNER, PATH, LOCK_DEPTH, EXPIRES_AT, EXCLUSIVE_LOCK, LOCK_TYPE, CHILDREN_ID, PARENT_ID, TEMP_LOCK ");
        query.append(" FROM ").append(this.lockingTableName);
        query.append(" WHERE PATH = :path AND TEMP_LOCK = :tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("path", (Object)path);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.getByPath()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {path: " + path + ", tempLock: " + tempLock + "}");
        return this.jdbcTemplate.query(query.toString(), (SqlParameterSource)mapParameterSource, this.dataBaseModelRowMapper);
    }

    @Override
    public List<DataBaseModel> getById(String id, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ID, OWNER, PATH, LOCK_DEPTH, EXPIRES_AT, EXCLUSIVE_LOCK, LOCK_TYPE, CHILDREN_ID, PARENT_ID, TEMP_LOCK ");
        query.append(" FROM ").append(this.lockingTableName);
        query.append(" WHERE ID = :id AND TEMP_LOCK = :tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("id", (Object)id);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.getById()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {id: " + id + ", tempLock: " + tempLock + "}");
        return this.jdbcTemplate.query(query.toString(), (SqlParameterSource)mapParameterSource, this.dataBaseModelRowMapper);
    }

    @Override
    public Boolean isLockedByPath(String path, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT count(1)");
        query.append(" FROM ").append(this.lockingTableName);
        query.append(" WHERE PATH = :path AND TEMP_LOCK=:tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("path", (Object)path);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.isLockedByPath()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {path: " + path + ", tempLock: " + tempLock + "}");
        if (this.jdbcTemplate.queryForInt(query.toString(), (SqlParameterSource)mapParameterSource) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isLockedById(String id, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT count(1) ");
        query.append(" FROM ").append(this.lockingTableName);
        query.append(" WHERE id = :id AND TEMP_LOCK=:tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("id", (Object)id);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.isLockedById()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {id: " + id + ", tempLock: " + tempLock + "}");
        if (this.jdbcTemplate.queryForInt(query.toString(), (SqlParameterSource)mapParameterSource) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public void deleteById(String id, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(this.lockingTableName);
        query.append(" WHERE ID=:id AND TEMP_LOCK=:tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("id", (Object)id);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.deleteById()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {id: " + id + ", tempLock: " + tempLock + "}");
        this.jdbcTemplate.update(query.toString(), (SqlParameterSource)mapParameterSource);
    }

    @Override
    public void deleteByPath(String path, Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(this.lockingTableName);
        query.append(" WHERE PATH=:path AND TEMP_LOCK=:tempLock");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("path", (Object)path);
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.deleteByPath()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {path: " + path + ", tempLock: " + tempLock + "}");
        this.jdbcTemplate.update(query.toString(), (SqlParameterSource)mapParameterSource);
    }

    @Override
    public void removeTimeoutLocks(Boolean tempLock) {
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(this.lockingTableName);
        query.append(" WHERE TEMP_LOCK=:tempLock AND EXPIRES_AT < :sysdate");
        MapSqlParameterSource mapParameterSource = new MapSqlParameterSource();
        mapParameterSource.addValue("sysdate", (Object)Calendar.getInstance().getTime().getTime());
        mapParameterSource.addValue("tempLock", (Object)tempLock);
        this.logger.debug("DataBaseLockDaoImpl.deleteByPath()");
        this.logger.debug("\tSQL: " + query.toString());
        this.logger.debug("\tparams: {tempLock: " + tempLock + "}");
        this.jdbcTemplate.update(query.toString(), (SqlParameterSource)mapParameterSource);
    }

    public void setLockingTableName(String lockingTableName) {
        this.lockingTableName = lockingTableName;
    }

    public void setLockingDataSource(DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }
}

