/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav;

import com.ejie.x38.webdav.IMethodExecutor;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.WebDavServletBean;
import com.ejie.x38.webdav.WebDavServletHelper;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;

public class WebdavSpringServlet
implements HttpRequestHandler {
    private static Logger LOG = LoggerFactory.getLogger(WebDavServletBean.class);
    private Boolean lazyFolderCreationOnPut;
    private String defaultIndexFile;
    private String insteadOf404;
    private Integer noContentLengthHeaders;
    private IWebdavStore webDavStore;
    private IResourceLocks resourceLocks;
    private HashMap<String, IMethodExecutor> _methodMap = new HashMap();
    protected static MessageDigest MD5_HELPER;

    @PostConstruct
    public void init() throws ServletException {
        try {
            MD5_HELPER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
        if (this.noContentLengthHeaders == null) {
            this.noContentLengthHeaders = new Integer(0);
        }
        if (this.lazyFolderCreationOnPut == null) {
            this.lazyFolderCreationOnPut = Boolean.FALSE;
        }
        if (this.resourceLocks == null) {
            LOG.error("No se ha configurado correctamente el gestor de locking de webDav");
            throw new WebdavException("No se ha configurado correctamente el gestor de locking de webDav");
        }
        WebDavServletHelper.registerWebDavMethods(this.webDavStore, this._methodMap, this.defaultIndexFile, this.insteadOf404, this.resourceLocks, this.noContentLengthHeaders, this.lazyFolderCreationOnPut, null);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDavServletHelper.processWebDav(request, response, this.webDavStore, this._methodMap);
    }

    public void setLazyFolderCreationOnPut(Boolean lazyFolderCreationOnPut) {
        this.lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    public void setDefaultIndexFile(String defaultIndexFile) {
        this.defaultIndexFile = defaultIndexFile;
    }

    public void setInsteadOf404(String insteadOf404) {
        this.insteadOf404 = insteadOf404;
    }

    public void setNoContentLengthHeaders(Integer noContentLengthHeaders) {
        this.noContentLengthHeaders = noContentLengthHeaders;
    }

    public void setWebDavStore(IWebdavStore webDavStore) {
        this.webDavStore = webDavStore;
    }

    public void setResourceLocks(IResourceLocks resourceLocks) {
        this.resourceLocks = resourceLocks;
    }
}

