/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav;

import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.LocalFileSystemStore;
import com.ejie.x38.webdav.WebDavServletBean;
import com.ejie.x38.webdav.exceptions.WebdavException;
import com.ejie.x38.webdav.locking.IResourceLocks;
import com.ejie.x38.webdav.locking.MemoryResourceLocks;
import java.io.File;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;

public class WebdavServlet
extends WebDavServletBean {
    private static final String ROOTPATH_PARAMETER = "rootpath";

    public void init() throws ServletException {
        String clazzName = this.getServletConfig().getInitParameter("ResourceHandlerImplementation");
        if (clazzName == null || clazzName.equals("")) {
            clazzName = LocalFileSystemStore.class.getName();
        }
        File root = this.getFileRoot();
        IWebdavStore webdavStore = this.constructStore(clazzName, root);
        String resourceLocksClazzName = this.getServletConfig().getInitParameter("ResourceLocksImplementation");
        if (resourceLocksClazzName == null || resourceLocksClazzName.equals("")) {
            resourceLocksClazzName = MemoryResourceLocks.class.getName();
        }
        this._resLocks = this.constructResourceLocks(resourceLocksClazzName);
        boolean lazyFolderCreationOnPut = this.getInitParameter("lazyFolderCreationOnPut") != null && this.getInitParameter("lazyFolderCreationOnPut").equals("1");
        String dftIndexFile = this.getInitParameter("default-index-file");
        String insteadOf404 = this.getInitParameter("instead-of-404");
        int noContentLengthHeader = this.getIntInitParameter("no-content-length-headers");
        super.init(webdavStore, dftIndexFile, insteadOf404, noContentLengthHeader, lazyFolderCreationOnPut);
    }

    private int getIntInitParameter(String key) {
        return this.getInitParameter(key) == null ? -1 : Integer.parseInt(this.getInitParameter(key));
    }

    protected IWebdavStore constructStore(String clazzName, File root) {
        IWebdavStore webdavStore;
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> ctor = clazz.getConstructor(File.class);
            webdavStore = (IWebdavStore)ctor.newInstance(root);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("some problem making store component", e);
        }
        return webdavStore;
    }

    protected IResourceLocks constructResourceLocks(String clazzName) {
        IResourceLocks resourceLocks;
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            resourceLocks = (IResourceLocks)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("some problem making store component", e);
        }
        return resourceLocks;
    }

    private File getFileRoot() {
        String rootPath = this.getInitParameter(ROOTPATH_PARAMETER);
        if (rootPath == null) {
            throw new WebdavException("missing parameter: rootpath");
        }
        if (rootPath.equals("*WAR-FILE-ROOT*")) {
            int ix;
            String file = LocalFileSystemStore.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace('\\', '/');
            if (file.charAt(0) == '/' && System.getProperty("os.name").indexOf("Windows") != -1) {
                file = file.substring(1, file.length());
            }
            if ((ix = file.indexOf("/WEB-INF/")) != -1) {
                rootPath = file.substring(0, ix).replace('/', File.separatorChar);
            } else {
                throw new WebdavException("Could not determine root of war file. Can't extract from path '" + file + "' for this web container");
            }
        }
        return new File(rootPath);
    }
}

