/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.webdav;

import com.ejie.x38.webdav.ITransaction;
import com.ejie.x38.webdav.IWebdavStore;
import com.ejie.x38.webdav.StoredObject;
import com.ejie.x38.webdav.exceptions.WebdavException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemStore
implements IWebdavStore {
    private Logger LOG = LoggerFactory.getLogger(LocalFileSystemStore.class);
    private static int BUF_SIZE = 65536;
    private File _root = null;
    private String rootPath;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public LocalFileSystemStore(File root) {
        this._root = root;
    }

    public LocalFileSystemStore() {
    }

    @PostConstruct
    public void init() {
        if (this._root == null && this.rootPath != null && this.rootPath != "") {
            if (this.rootPath.equals("*WAR-FILE-ROOT*")) {
                int ix;
                String file = LocalFileSystemStore.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace('\\', '/');
                if (file.charAt(0) == '/' && System.getProperty("os.name").indexOf("Windows") != -1) {
                    file = file.substring(1, file.length());
                }
                if ((ix = file.indexOf("/WEB-INF/")) != -1) {
                    this.rootPath = file.substring(0, ix).replace('/', File.separatorChar);
                } else {
                    throw new WebdavException("Could not determine root of war file. Can't extract from path '" + file + "' for this web container");
                }
            }
            this._root = new File(this.rootPath);
        }
    }

    @Override
    public ITransaction begin(Principal principal) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.begin()");
        if (!this._root.exists() && !this._root.mkdirs()) {
            throw new WebdavException("root path: " + this._root.getAbsolutePath() + " does not exist and could not be created");
        }
        return null;
    }

    @Override
    public void checkAuthentication(ITransaction transaction) throws SecurityException {
        this.LOG.debug("LocalFileSystemStore.checkAuthentication()");
    }

    @Override
    public void commit(ITransaction transaction) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.commit()");
    }

    @Override
    public void rollback(ITransaction transaction) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.rollback()");
    }

    @Override
    public void createFolder(ITransaction transaction, String uri) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.createFolder(" + uri + ")");
        File file = new File(this._root, uri);
        if (!file.mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    @Override
    public void createResource(ITransaction transaction, String uri) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.createResource(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            this.LOG.error("LocalFileSystemStore.createResource(" + uri + ") failed");
            throw new WebdavException(e);
        }
    }

    @Override
    public long setResourceContent(ITransaction transaction, String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.setResourceContent(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), BUF_SIZE);
            try {
                int read;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            this.LOG.error("LocalFileSystemStore.setResourceContent(" + uri + ") failed");
            throw new WebdavException(e);
        }
        long length = -1L;
        try {
            length = file.length();
        }
        catch (SecurityException e) {
            this.LOG.error("LocalFileSystemStore.setResourceContent(" + uri + ") failed" + "\nCan't get file.length");
        }
        return length;
    }

    @Override
    public String[] getChildrenNames(ITransaction transaction, String uri) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.getChildrenNames(" + uri + ")");
        File file = new File(this._root, uri);
        String[] childrenNames = null;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            String name = null;
            int i = 0;
            while (i < children.length) {
                name = children[i].getName();
                childList.add(name);
                this.LOG.debug("Child " + i + ": " + name);
                ++i;
            }
            childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
        }
        return childrenNames;
    }

    @Override
    public void removeObject(ITransaction transaction, String uri) throws WebdavException {
        File file = new File(this._root, uri);
        boolean success = file.delete();
        this.LOG.debug("LocalFileSystemStore.removeObject(" + uri + ")=" + success);
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    @Override
    public InputStream getResourceContent(ITransaction transaction, String uri) throws WebdavException {
        BufferedInputStream in;
        this.LOG.debug("LocalFileSystemStore.getResourceContent(" + uri + ")");
        File file = new File(this._root, uri);
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            this.LOG.error("LocalFileSystemStore.getResourceContent(" + uri + ") failed");
            throw new WebdavException(e);
        }
        return in;
    }

    @Override
    public long getResourceLength(ITransaction transaction, String uri) throws WebdavException {
        this.LOG.debug("LocalFileSystemStore.getResourceLength(" + uri + ")");
        File file = new File(this._root, uri);
        return file.length();
    }

    @Override
    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        StoredObject so = null;
        File file = new File(this._root, uri);
        if (file.exists()) {
            so = new StoredObject();
            so.setFolder(file.isDirectory());
            so.setLastModified(new Date(file.lastModified()));
            so.setCreationDate(new Date(file.lastModified()));
            so.setResourceLength(this.getResourceLength(transaction, uri));
        }
        return so;
    }
}

