/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.rss.security;

import com.ejie.x38.rss.exception.RssAuthenticationException;
import com.ejie.x38.util.XmlManager;
import com.ejie.x38.webdav.security.WebDAVHttpServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import n38a.exe.N38APISesion;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RssXLNetsAutenticationHelper {
    private static final String ERROR_TYPE_INFO = "informacion";
    private static final String ERROR_TYPE_WARNING = "warning";
    private static final String ERROR_TYPE_ERROR = "error";
    private static final String XPATH_N38_ROOT = "/n38";
    private static final String XPATH_N38UIDSESION = "/n38/elementos/elemento[@subtipo='N38Sesion']/parametro[@id='n38uidsesion']/valor";
    private static final String XPATH_N38DOMINIOUID = "/n38/elementos/elemento[@subtipo='N38Sesion']/parametro[@id='n38dominiouid']/valor";

    public static void checkSecuritySesionValid(Node nodo) {
        if (nodo == null) {
            return;
        }
        try {
            Node nodeN38 = XmlManager.searchDomNode((Node)nodo, (String)XPATH_N38_ROOT);
            Node node = nodeN38.getFirstChild();
            if (ERROR_TYPE_INFO.equalsIgnoreCase(node.getNodeName())) {
                throw new RssAuthenticationException(RssXLNetsAutenticationHelper.getErrorString(node, ERROR_TYPE_INFO));
            }
            if (ERROR_TYPE_WARNING.equalsIgnoreCase(node.getNodeName())) {
                throw new RssAuthenticationException(RssXLNetsAutenticationHelper.getErrorString(node, ERROR_TYPE_WARNING));
            }
            if (ERROR_TYPE_ERROR.equalsIgnoreCase(node.getNodeName())) {
                throw new RssAuthenticationException(RssXLNetsAutenticationHelper.getErrorString(node, ERROR_TYPE_ERROR));
            }
        }
        catch (TransformerException e) {
            throw new RssAuthenticationException("Se ha producido un error a la hora de validar el xml de sesi\u00f3n de XLNets", e);
        }
    }

    public static HttpServletRequest createXLNetsSessionUP(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        String searchDomNodeDominioUid;
        String searchDomNodeUidSesion;
        N38APISesion n38APISession = new N38APISesion(request);
        Document n38apiSesionCrearUP = n38APISession.n38APISesionCrearUP(username, password);
        RssXLNetsAutenticationHelper.checkSecuritySesionValid(n38apiSesionCrearUP);
        WebDAVHttpServletRequestWrapper wrapedRequest = new WebDAVHttpServletRequestWrapper(request);
        wrapedRequest.getSession(true);
        try {
            searchDomNodeUidSesion = XmlManager.searchDomNode((Node)n38apiSesionCrearUP, (String)XPATH_N38UIDSESION).getFirstChild().getNodeValue();
            searchDomNodeDominioUid = XmlManager.searchDomNode((Node)n38apiSesionCrearUP, (String)XPATH_N38DOMINIOUID).getFirstChild().getNodeValue();
        }
        catch (TransformerException e) {
            throw new RssAuthenticationException("Se ha producido un error a la hora de validar el xml de sesi\u00f3n de XLNets", e);
        }
        wrapedRequest.addCookie(new Cookie("n38UidSesion", searchDomNodeUidSesion));
        wrapedRequest.addCookie(new Cookie("n38DominioUid", searchDomNodeDominioUid));
        return wrapedRequest;
    }

    private static String getErrorString(Node node, String type) throws DOMException, TransformerException {
        String codigo = XmlManager.searchDomNode((Node)node, (String)("/n38/" + type + "/@codigo")).getNodeValue();
        String descripcion = XmlManager.searchDomNode((Node)node, (String)("/n38/" + type + "/descripcionCA/text()")).getNodeValue();
        String motivo = XmlManager.searchDomNode((Node)node, (String)("/n38/" + type + "/motivo/text()")).getNodeValue();
        return "XLNets Error Code '" + codigo + "': " + descripcion + " -- " + motivo;
    }
}

