/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.rss.security;

import com.ejie.x38.rss.exception.RssInitializationException;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public class RssBasicAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    @Autowired(required=false)
    private ReloadableResourceBundleMessageSource messageSource;
    private String i18nRealmName;

    public void afterPropertiesSet() throws Exception {
        if (this.i18nRealmName != null && this.messageSource == null) {
            throw new RssInitializationException("No se puede resolver el valor de la propiedad i18nRealmName al no existir un bean messageSource definido");
        }
        if (this.i18nRealmName != null) {
            this.setRealmName(this.messageSource.getMessage(this.i18nRealmName, null, LocaleContextHolder.getLocale()));
        }
        super.afterPropertiesSet();
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String content = authException.getMessage();
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealmName() + "\"");
        response.setStatus(401);
        response.setContentLength(content.getBytes(Charset.forName(response.getCharacterEncoding())).length);
        response.getWriter().print(content);
        response.flushBuffer();
    }

    public String getI18nRealmName() {
        return this.i18nRealmName;
    }

    public void setI18nRealmName(String i18nRealmName) {
        this.i18nRealmName = i18nRealmName;
    }
}

