/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.rss;

import com.ejie.x38.rss.RssContent;
import com.ejie.x38.rss.exception.RssInitializationException;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Content;
import com.sun.syndication.feed.rss.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.view.feed.AbstractRssFeedView;

public class RssFeedView
extends AbstractRssFeedView {
    private String title;
    private String descripcion;
    private String link;
    private String i18nTitle;
    private String i18nDescripcion;
    @Autowired(required=false)
    private ReloadableResourceBundleMessageSource messageSource;

    protected void buildFeedMetadata(Map<String, Object> model, Channel feed, HttpServletRequest request) {
        if (this.i18nTitle != null && this.i18nDescripcion != null && this.messageSource == null) {
            throw new RssInitializationException("No se puede resolver el valor de la propiedad i18nTitle al no existir un bean messageSource definido");
        }
        if (this.i18nDescripcion != null && this.messageSource == null) {
            throw new RssInitializationException("No se puede resolver el valor de la propiedad i18nDescripcion al no existir un bean messageSource definido");
        }
        if (this.i18nTitle != null) {
            feed.setTitle(this.messageSource.getMessage(this.i18nTitle, null, LocaleContextHolder.getLocale()));
        } else {
            feed.setTitle(this.title);
        }
        if (this.i18nDescripcion != null) {
            feed.setDescription(this.messageSource.getMessage(this.i18nDescripcion, null, LocaleContextHolder.getLocale()));
        } else {
            feed.setDescription(this.descripcion);
        }
        feed.setLink(this.link);
        super.buildFeedMetadata(model, (WireFeed)feed, request);
    }

    protected List<Item> buildFeedItems(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List listContent = (List)model.get("feedContent");
        ArrayList<Item> items = new ArrayList<Item>(listContent.size());
        for (RssContent rssContent : listContent) {
            Item item = new Item();
            Content content = new Content();
            content.setValue(rssContent.getDescription());
            item.setContent(content);
            item.setTitle(rssContent.getTitle());
            item.setLink(rssContent.getLink());
            item.setPubDate(rssContent.getPubDate());
            items.add(item);
        }
        return items;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setI18nTitle(String i18nTitle) {
        this.i18nTitle = i18nTitle;
    }

    public void setI18nDescripcion(String i18nDescripcion) {
        this.i18nDescripcion = i18nDescripcion;
    }
}

