/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.Util;

final class WindowsSelectorImpl
extends SelectorImpl {
    private final Pipe wakeupPipe;
    private final Object interruptLock = new Object();
    private final int wakeupSourceFd;
    private final int wakeupSinkFd;
    private boolean interruptTriggered;
    PollArrayWrapper pollWrapper = new PollArrayWrapper(10);
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray = new SelectionKeyImpl[10];
    protected int totalChannels = 1;
    private boolean closed = false;

    WindowsSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.wakeupPipe = Pipe.open();
        this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
        SinkChannelImpl sink = (SinkChannelImpl)this.wakeupPipe.sink();
        sink.sc.socket().setTcpNoDelay(true);
        this.wakeupSinkFd = sink.getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long timeout) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        try {
            this.begin();
            this.pollWrapper.poll(this.totalChannels, 0, timeout);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int numKeysUpdated = this.updateSelectedKeys();
        this.resetWakeupSocket();
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.setWakeupSocket();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    private void implCloseInterrupt() throws IOException {
        try {
            this.wakeupPipe.sink().close();
            this.wakeupPipe.source().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                return;
            }
            this.resetWakeupSocket0(this.wakeupSourceFd);
            this.interruptTriggered = false;
        }
    }

    void putEventOps(SelectionKeyImpl sk, int ops) {
        this.pollWrapper.putEventOps(sk.getIndex(), ops);
    }

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (int i = 1; i < this.totalChannels; ++i) {
                SelectionKeyImpl ski = this.channelArray[i];
                assert (ski.getIndex() != -1);
                ski.setIndex(-1);
                this.deregister(ski);
                SelectableChannel selch = this.channelArray[i].channel();
                if (selch.isOpen() || selch.isRegistered()) continue;
                ((SelChImpl)((Object)selch)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
        }
    }

    protected int updateSelectedKeys() {
        int numKeysUpdated = 0;
        for (int i = 1; i < this.totalChannels; ++i) {
            int rOps = this.pollWrapper.getReventOps(i);
            if (rOps == 0) continue;
            SelectionKeyImpl sk = this.channelArray[i];
            this.pollWrapper.putReventOps(i, 0);
            if (this.selectedKeys.contains(sk)) {
                if (!sk.channel.translateAndSetReadyOps(rOps, sk)) continue;
                ++numKeysUpdated;
                continue;
            }
            sk.channel.translateAndSetReadyOps(rOps, sk);
            if ((sk.nioReadyOps() & sk.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(sk);
            ++numKeysUpdated;
        }
        return numKeysUpdated;
    }

    protected void implRegister(SelectionKeyImpl ski) {
        if (this.channelArray.length == this.totalChannels) {
            int newSize = this.totalChannels + 64;
            SelectionKeyImpl[] temp = new SelectionKeyImpl[newSize];
            for (int i = 1; i < this.totalChannels; ++i) {
                temp[i] = this.channelArray[i];
            }
            this.channelArray = temp;
            this.pollWrapper.grow(newSize);
        }
        this.channelArray[this.totalChannels] = ski;
        ski.setIndex(this.totalChannels);
        this.pollWrapper.addEntry(this.totalChannels, ski);
        ++this.totalChannels;
        this.keys.add(ski);
    }

    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        int i = ski.getIndex();
        assert (i >= 0);
        if (i != this.totalChannels - 1) {
            SelectionKeyImpl endChannel;
            this.channelArray[i] = endChannel = this.channelArray[this.totalChannels - 1];
            endChannel.setIndex(i);
            this.pollWrapper.release(i);
            PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, i);
        } else {
            this.pollWrapper.release(i);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        ski.setIndex(-1);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void resetWakeupSocket0(int var1);

    private native void setWakeupSocket0(int var1);

    static {
        System.loadLibrary("net");
        System.loadLibrary("nio");
        Util.load();
    }
}

