/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.misc.Unsafe;
import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.SelectionKeyImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    private static final int ADDRESS_SIZE;
    private int size;

    private static int size(int n) {
        return n * 8 + 3 * ADDRESS_SIZE + 3 * n * ADDRESS_SIZE;
    }

    PollArrayWrapper(int newSize) {
        this.pollArray = new AllocatedNativeObject(PollArrayWrapper.size(newSize + 1), false);
        this.pollArrayAddress = this.pollArray.address();
        this.size = newSize;
    }

    void release(int i) {
    }

    void free() {
        this.pollArray.free();
    }

    void addEntry(int index, SelectionKeyImpl ski) {
        this.putDescriptor(index, ski.channel.getFDVal());
        this.putEventOps(index, 0);
        this.putReventOps(index, 0);
    }

    static void replaceEntry(PollArrayWrapper source, int sindex, PollArrayWrapper target, int tindex) {
        target.putDescriptor(tindex, source.getDescriptor(sindex));
        target.putEventOps(tindex, source.getEventOps(sindex));
        target.putReventOps(tindex, source.getReventOps(sindex));
    }

    void grow(int newSize) {
        PollArrayWrapper temp = new PollArrayWrapper(newSize);
        for (int i = 0; i < this.size; ++i) {
            PollArrayWrapper.replaceEntry(this, i, temp, i);
        }
        this.pollArray.free();
        this.pollArray = temp.pollArray;
        this.size = temp.size;
        this.pollArrayAddress = this.pollArray.address();
    }

    int poll(int numfds, int offset, long timeout) {
        return this.poll0(this.pollArrayAddress + (long)(offset * 8), numfds, timeout);
    }

    void addWakeupSocket(int fdVal, int index) {
        this.putDescriptor(index, fdVal);
        this.putEventOps(index, 1);
    }

    private native int poll0(long var1, int var3, long var4);

    static {
        System.loadLibrary("orii");
        ADDRESS_SIZE = Unsafe.getUnsafe().addressSize();
    }
}

