/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    private static final int MAX_IOVEC = 16;
    private static final ThreadLocal<IOVecData> iovecLocal = new ThreadLocal<IOVecData>(){

        @Override
        protected IOVecData initialValue() {
            return new IOVecData();
        }
    };

    private IOUtil() {
    }

    private static IOVecData prepareIOVec(ByteBuffer[] bufs, int offset, int length) {
        IOVecData d = iovecLocal.get();
        d.length = 0;
        int dPos = 0;
        for (int i = 0; i < length; ++i) {
            int rem;
            ByteBuffer b = bufs[offset + i];
            int pos = b.position();
            int lim = b.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (rem == 0) continue;
            if (b instanceof DirectBuffer) {
                d.byteArrays[dPos] = null;
                d.addresses[dPos] = ((DirectBuffer)((Object)b)).address();
                d.offsets[dPos] = pos;
                d.lengths[dPos] = rem;
            } else {
                if (b.hasArray()) {
                    d.byteArrays[dPos] = b.array();
                    d.offsets[dPos] = b.arrayOffset() + pos;
                } else {
                    d.byteArrays[dPos] = new byte[rem];
                    b.get(d.byteArrays[dPos]);
                    b.position(pos);
                    d.offsets[dPos] = 0;
                }
                d.addresses[dPos] = 0L;
                d.lengths[dPos] = rem;
            }
            if (++dPos == 16) break;
        }
        d.length = dPos;
        return d;
    }

    private static void updateBuffers(IOVecData d, ByteBuffer[] bufs, int offset, int length, long written) {
        int i;
        for (i = 0; i < d.length; ++i) {
            d.byteArrays[i] = null;
        }
        for (i = 0; i < length; ++i) {
            int newPosition;
            int len;
            ByteBuffer b = bufs[offset + i];
            int pos = b.position();
            int lim = b.limit();
            assert (pos <= lim);
            int n = len = pos <= lim ? lim - pos : 0;
            if (len == 0) continue;
            if (written >= (long)len) {
                written -= (long)len;
                newPosition = pos + len;
                b.position(newPosition);
                continue;
            }
            if (written > 0L) {
                assert ((long)pos + written < Integer.MAX_VALUE);
                newPosition = (int)((long)pos + written);
                b.position(newPosition);
            }
            return;
        }
    }

    static int write(FileDescriptor fd, ByteBuffer src, long position, NativeDispatcher nd, Object lock) throws IOException {
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int written = 0;
        if (rem == 0) {
            return 0;
        }
        if (src instanceof DirectBuffer) {
            long address = ((DirectBuffer)((Object)src)).address() + (long)pos;
            written = position != -1L ? nd.pwrite(fd, address, rem, position, lock) : nd.write(fd, address, rem);
        } else {
            byte[] bytes = null;
            int off = 0;
            if (src.hasArray()) {
                bytes = src.array();
                off = src.arrayOffset() + pos;
            } else {
                bytes = new byte[rem];
                src.get(bytes);
                src.position(pos);
            }
            written = position != -1L ? nd.pwrite(fd, bytes, off, rem, position, lock) : nd.write(fd, bytes, off, rem);
        }
        if (written > 0) {
            src.position(pos + written);
        }
        return written;
    }

    static long write(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        return IOUtil.write(fd, bufs, 0, bufs.length, nd);
    }

    static long write(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, NativeDispatcher nd) throws IOException {
        IOVecData d = IOUtil.prepareIOVec(bufs, offset, length);
        if (d.length == 0) {
            return 0L;
        }
        long written = nd.writev(fd, d.addresses, d.offsets, d.lengths, d.byteArrays, d.length);
        if (written > 0L) {
            IOUtil.updateBuffers(d, bufs, offset, length, written);
        }
        return written;
    }

    static int read(FileDescriptor fd, ByteBuffer dst, long position, NativeDispatcher nd, Object lock) throws IOException {
        int rem;
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem == 0) {
            return 0;
        }
        int n2 = 0;
        if (dst instanceof DirectBuffer) {
            long address = ((DirectBuffer)((Object)dst)).address() + (long)pos;
            n2 = position != -1L ? nd.pread(fd, address, rem, position, lock) : nd.read(fd, address, rem);
        } else {
            byte[] bytes = dst.array();
            int off = dst.arrayOffset() + pos;
            n2 = position != -1L ? nd.pread(fd, bytes, off, rem, position, lock) : nd.read(fd, bytes, off, rem);
        }
        if (n2 > 0) {
            dst.position(pos + n2);
        }
        return n2;
    }

    static long read(FileDescriptor fd, ByteBuffer[] bufs, NativeDispatcher nd) throws IOException {
        return IOUtil.read(fd, bufs, 0, bufs.length, nd);
    }

    static long read(FileDescriptor fd, ByteBuffer[] bufs, int offset, int length, NativeDispatcher nd) throws IOException {
        IOVecData d = IOUtil.prepareIOVec(bufs, offset, length);
        if (d.length == 0) {
            return 0L;
        }
        long n = nd.readv(fd, d.addresses, d.offsets, d.lengths, d.byteArrays, d.length);
        if (n > 0L) {
            IOUtil.updateBuffers(d, bufs, offset, length, n);
        }
        return n;
    }

    static FileDescriptor newFD(int i) {
        FileDescriptor fd = new FileDescriptor();
        IOUtil.setfdVal(fd, i);
        return fd;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        Util.load();
    }

    private static class IOVecData {
        long[] addresses = new long[16];
        byte[][] byteArrays = new byte[16][];
        int[] offsets = new int[16];
        int[] lengths = new int[16];
        int length;

        IOVecData() {
        }
    }
}

