/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.text;

import java.util.concurrent.TimeUnit;

public final class StringParse {
    private StringParse() {
    }

    public static boolean bool(String v) {
        if (v == null) {
            return true;
        }
        return v.equalsIgnoreCase("true") || v.equals("1");
    }

    public static long nanos(String s) {
        if (s.endsWith("ns")) {
            return Long.parseLong(s.substring(0, s.length() - 2));
        }
        if (s.endsWith("us")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 2)), TimeUnit.MICROSECONDS);
        }
        if (s.endsWith("ms")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 2)), TimeUnit.MILLISECONDS);
        }
        if (s.endsWith("s")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1)), TimeUnit.SECONDS);
        }
        if (s.endsWith("m")) {
            return 60L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1)), TimeUnit.SECONDS);
        }
        if (s.endsWith("h")) {
            return 3600L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1)), TimeUnit.SECONDS);
        }
        if (s.endsWith("d")) {
            return 86400L * TimeUnit.NANOSECONDS.convert(Long.parseLong(s.substring(0, s.length() - 1)), TimeUnit.SECONDS);
        }
        long value = Long.parseLong(s);
        if (value != 0L) {
            throw new NumberFormatException("Could not parse time, missing unit.");
        }
        return value;
    }

    public static long size(String v) {
        int multi = 1;
        if (v.endsWith("k") || v.endsWith("K")) {
            multi = 1024;
            v = v.substring(0, v.length() - 1);
        } else if (v.endsWith("m") || v.endsWith("M")) {
            multi = 0x100000;
            v = v.substring(0, v.length() - 1);
        } else if (v.endsWith("g") || v.endsWith("G")) {
            multi = 0x40000000;
            v = v.substring(0, v.length() - 1);
        }
        return Integer.parseInt(v) * multi;
    }
}

