/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.text;

import java.util.regex.Pattern;

public class GlobPattern {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;

    public static Pattern compile(String globString, int flags) {
        String s = GlobPattern.globToPerl5(globString.toCharArray(), flags);
        return Pattern.compile(s);
    }

    public static Pattern compile(String globString) {
        return GlobPattern.compile(globString, 0);
    }

    private static boolean isPerl5MetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '+' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '|' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '\\';
    }

    private static boolean isGlobMetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '[' || ch == ']';
    }

    private static String globToPerl5(char[] pattern, int options) {
        boolean starCannotMatchNull = false;
        StringBuilder buffer = new StringBuilder(2 * pattern.length);
        boolean inCharSet = false;
        boolean questionMatchesZero = (options & 4) != 0;
        starCannotMatchNull = (options & 2) != 0;
        block11: for (int ch = 0; ch < pattern.length; ++ch) {
            switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    if (starCannotMatchNull) {
                        buffer.append(".+");
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    if (questionMatchesZero) {
                        buffer.append(".?");
                        continue block11;
                    }
                    buffer.append('.');
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) continue block11;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (GlobPattern.isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && GlobPattern.isPerl5MetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
        }
        return buffer.toString();
    }
}

