/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.os;

public final class Timing {
    private static final long COUNTER_FREQ;
    private static final double COUNTER_TO_NANO;
    private static final double COUNTER_TO_MICRO;
    private static final double COUNTER_TO_MILLI;
    private static final double COUNTER_TO_SECOND;

    private static native long init();

    private Timing() {
    }

    public static native long counterTime();

    public static long counterFrequency() {
        return COUNTER_FREQ;
    }

    public static double counterToNano(double ct) {
        return COUNTER_TO_NANO * ct;
    }

    public static double counterToMicro(double ct) {
        return COUNTER_TO_MICRO * ct;
    }

    public static double counterToMilli(double ct) {
        return COUNTER_TO_MILLI * ct;
    }

    public static double counterToSecond(double ct) {
        return COUNTER_TO_SECOND * ct;
    }

    public static long counterToNano(long ct) {
        return (long)Timing.counterToNano((double)ct);
    }

    public static long counterToMilli(long ct) {
        return (long)Timing.counterToMilli((double)ct);
    }

    public static long counterToMicro(long ct) {
        return (long)Timing.counterToMicro((double)ct);
    }

    public static long counterToSecond(long ct) {
        return (long)Timing.counterToSecond((double)ct);
    }

    public static long nanoToCounter(long nt) {
        return (long)((double)nt / COUNTER_TO_NANO);
    }

    public static double countersToNanos(double start, double end) {
        return Timing.counterToNano(end - start);
    }

    public static double countersToMicros(double start, double end) {
        return Timing.counterToMicro(start - end);
    }

    public static double countersToMillis(double start, double end) {
        return Timing.counterToMilli(start - end);
    }

    public static double countersToSeconds(double start, double end) {
        return Timing.counterToSecond(start - end);
    }

    public static long countersToNanos(long start, long end) {
        return Timing.counterToNano(end - start);
    }

    public static long countersToMicros(long start, long end) {
        return Timing.counterToMicro(start - end);
    }

    public static long countersToMillis(long start, long end) {
        return Timing.counterToMilli(start - end);
    }

    public static long countersToSeconds(long start, long end) {
        return Timing.counterToSecond(start - end);
    }

    public static long millisToCounter(double time) {
        return (long)(time * (double)COUNTER_FREQ / 1000.0);
    }

    static {
        System.loadLibrary("util");
        COUNTER_FREQ = Timing.init();
        COUNTER_TO_NANO = 1.0 / ((double)COUNTER_FREQ / 1.0E9);
        COUNTER_TO_MICRO = 1.0 / ((double)COUNTER_FREQ / 1000000.0);
        COUNTER_TO_MILLI = 1.0 / ((double)COUNTER_FREQ / 1000.0);
        COUNTER_TO_SECOND = 1.0 / (double)COUNTER_FREQ;
    }
}

