/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server.sun;

import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SunAccessFileCheckerAuthenticator
implements JMXAuthenticator {
    private final Map<String, Object> env;
    private final Properties properties;
    private final String accessFile;

    public SunAccessFileCheckerAuthenticator(Map<String, Object> env) throws IOException {
        this.env = env;
        this.accessFile = (String)env.get("jmx.remote.x.access.file");
        this.properties = new Properties();
        if (this.accessFile != null) {
            FileInputStream fin = new FileInputStream(this.accessFile);
            this.properties.load(fin);
            fin.close();
        }
    }

    @Override
    public Subject authenticate(Object credentials) {
        JMXPluggableAuthenticator authenticator = new JMXPluggableAuthenticator(this.env);
        Subject subject = authenticator.authenticate(credentials);
        this.checkAccessFileEntries(subject);
        return subject;
    }

    private void checkAccessFileEntries(Subject subject) {
        if (subject == null) {
            throw new SecurityException("Access denied! No matching entries found in the access file [" + this.accessFile + "] as the " + "authenticated Subject is null");
        }
        Set<Principal> principals = subject.getPrincipals();
        for (Principal p : principals) {
            if (!this.properties.containsKey(p.getName())) continue;
            return;
        }
        HashSet<String> principalsStr = new HashSet<String>();
        for (Principal p : principals) {
            principalsStr.add(p.getName());
        }
        throw new SecurityException("Access denied! No entries found in the access file [" + this.accessFile + "] for any of the authenticated identities " + principalsStr);
    }
}

