/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server.sun;

import com.sun.jmx.remote.internal.RMIExporter;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import sun.rmi.registry.RegistryImpl;

class SingleEntryRegistry
extends RegistryImpl {
    private final RMIExporter exporter;
    private final String name;
    private final Remote object;

    SingleEntryRegistry(int port, String name, Remote object, RMIExporter exporter) throws RemoteException {
        super(port);
        this.name = name;
        this.object = object;
        this.exporter = exporter;
    }

    SingleEntryRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, String name, Remote object, RMIExporter exporter) throws RemoteException {
        super(port, csf, ssf);
        this.name = name;
        this.object = object;
        this.exporter = exporter;
    }

    public String[] list() {
        return new String[]{this.name};
    }

    public Remote lookup(String name) throws NotBoundException {
        if (name.equals(this.name)) {
            return this.object;
        }
        throw new NotBoundException("Not bound: \"" + name + "\" (only " + "bound name is \"" + this.name + "\")");
    }

    public void bind(String name, Remote obj) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    public void rebind(String name, Remote obj) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    public void unbind(String name) throws AccessException {
        throw new AccessException("Cannot modify this registry");
    }

    public void destroy() {
        if (this.exporter != null) {
            try {
                this.exporter.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }
}

