/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server.sun;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.HostServerSocketFactory;
import oracle.jrockit.management.server.RemoteJMXConnector;
import oracle.jrockit.management.server.sun.SingleEntryRegistry;
import oracle.jrockit.management.server.sun.SunAccessFileCheckerAuthenticator;
import oracle.jrockit.management.server.sun.SunRMIExporter;
import sun.management.FileSystem;
import sun.management.jmxremote.SSLContextRMIServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteJMXConnectorImpl
extends RemoteJMXConnector {
    private SingleEntryRegistry registry;

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.registry != null) {
            this.registry.destroy();
            this.registry = null;
        }
    }

    @Override
    protected final JMXConnectorServer newServer(MBeanServer mbs, Map<String, Object> env, String host, int port, int serverPort, boolean useSsl, boolean useRegistrySsl, String sslConfigFileName, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, boolean useAuthentication, String loginConfigName, String passwordFileName, String accessFileName) throws IOException, MalformedURLException {
        SunRMIExporter exporter = new SunRMIExporter();
        env.put("com.sun.jmx.remote.rmi.exporter", exporter);
        if (useAuthentication) {
            if (loginConfigName != null) {
                env.put("jmx.remote.x.login.config", loginConfigName);
            }
            if (passwordFileName != null) {
                env.put("jmx.remote.x.password.file", passwordFileName);
            }
            env.put("jmx.remote.x.access.file", accessFileName);
            if (env.get("jmx.remote.x.password.file") != null || env.get("jmx.remote.x.login.config") != null) {
                env.put("jmx.remote.authenticator", new SunAccessFileCheckerAuthenticator(env));
            }
        }
        SslRMIClientSocketFactory csf = null;
        RMIServerSocketFactory ssf = null;
        if (useSsl || useRegistrySsl) {
            csf = new SslRMIClientSocketFactory();
            ssf = RemoteJMXConnectorImpl.createSslRMIServerSocketFactory(sslConfigFileName, enabledCipherSuites, enabledProtocols, sslNeedClientAuth);
        }
        if (useSsl) {
            env.put("jmx.remote.rmi.client.socket.factory", csf);
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if (host != null) {
            ssf = new HostServerSocketFactory(host, ssf);
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        JMXConnectorServer cs = super.newServer(mbs, env, host, port, serverPort, false, false, null, null, null, false, useAuthentication, loginConfigName, passwordFileName, accessFileName);
        if (!useRegistrySsl && useSsl && host != null) {
            ssf = new HostServerSocketFactory(host, null);
        }
        this.registry = useRegistrySsl || host != null ? new SingleEntryRegistry(port, csf, ssf, "jmxrmi", exporter.firstExported, exporter) : new SingleEntryRegistry(port, "jmxrmi", exporter.firstExported, exporter);
        return cs;
    }

    public static void checkRestrictedFile(String restrictedFileName) {
        if (restrictedFileName == null || restrictedFileName.length() == 0) {
            throw new AgentError("agent.err.file.not.set");
        }
        File file = new File(restrictedFileName);
        if (!file.exists()) {
            throw new AgentError("agent.err.file.not.found", restrictedFileName);
        }
        if (!file.canRead()) {
            throw new AgentError("agent.err.file.not.readable", restrictedFileName);
        }
        FileSystem fs = FileSystem.open();
        try {
            if (fs.supportsFileSecurity(file) && !fs.isAccessUserOnly(file)) {
                throw new AgentError("agent.err.file.access.not.restricted", restrictedFileName);
            }
        }
        catch (IOException e) {
            throw new AgentError("agent.err.file.read.failed", restrictedFileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SslRMIServerSocketFactory createSslRMIServerSocketFactory(String sslConfigFileName, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth) {
        if (sslConfigFileName == null) {
            return new SslRMIServerSocketFactory(enabledCipherSuites, enabledProtocols, sslNeedClientAuth);
        }
        RemoteJMXConnectorImpl.checkRestrictedFile(sslConfigFileName);
        try {
            Properties p = new Properties();
            FileInputStream in = new FileInputStream(sslConfigFileName);
            try {
                BufferedInputStream bin = new BufferedInputStream(in);
                p.load(bin);
            }
            finally {
                ((InputStream)in).close();
            }
            String keyStore = p.getProperty("javax.net.ssl.keyStore");
            String keyStorePassword = p.getProperty("javax.net.ssl.keyStorePassword");
            String trustStore = p.getProperty("javax.net.ssl.trustStore");
            String trustStorePassword = p.getProperty("javax.net.ssl.trustStorePassword");
            char[] keyStorePasswd = null;
            if (keyStorePassword != null) {
                keyStorePasswd = keyStorePassword.toCharArray();
            }
            char[] trustStorePasswd = null;
            if (trustStorePassword != null) {
                trustStorePasswd = trustStorePassword.toCharArray();
            }
            KeyStore ks = null;
            if (keyStore != null) {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream ksfis = new FileInputStream(keyStore);
                try {
                    ks.load(ksfis, keyStorePasswd);
                }
                finally {
                    ksfis.close();
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePasswd);
            KeyStore ts = null;
            if (trustStore != null) {
                ts = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream tsfis = new FileInputStream(trustStore);
                try {
                    ts.load(tsfis, trustStorePasswd);
                }
                finally {
                    tsfis.close();
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return new SSLContextRMIServerSocketFactory(ctx, enabledCipherSuites, enabledProtocols, sslNeedClientAuth);
        }
        catch (Exception e) {
            throw new AgentError(e);
        }
    }

    @Override
    protected final void checkPasswordFile(String passwordFileName) {
        super.checkPasswordFile(passwordFileName);
        File file = new File(passwordFileName);
        FileSystem fs = FileSystem.open();
        try {
            if (fs.supportsFileSecurity(file) && !fs.isAccessUserOnly(file)) {
                throw new AgentError("agent.err.password.file.access.notrestricted", passwordFileName);
            }
        }
        catch (IOException e) {
            throw new AgentError("agent.err.password.file.read.failed", passwordFileName, e);
        }
    }
}

