/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server.sun;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import oracle.jrockit.management.server.LocalJMXConnector;
import oracle.jrockit.management.server.Messages;
import oracle.jrockit.management.server.sun.SunRMIExporter;
import sun.management.ConnectorAddressLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalJMXConnectorImpl
extends LocalJMXConnector {
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    private Properties agentProperties;

    @Override
    public synchronized void start(Properties p) {
        if (this.isStarted()) {
            Messages.info("agent.info.local.jmx.running", new Object[0]);
            return;
        }
        super.start(p);
        String address = this.address();
        Properties agentProps = this.getAgentProperties();
        agentProps.setProperty(LOCAL_CONNECTOR_ADDRESS_PROP, address);
        try {
            ConnectorAddressLink.export(address);
        }
        catch (Exception x) {
            Messages.warning("agent.err.exportaddress.failed", x);
        }
    }

    @Override
    protected JMXConnectorServer startNewServerImpl(MBeanServer mbs, Map<String, Object> env, JMXServiceURL url) throws IOException {
        env.put("com.sun.jmx.remote.rmi.exporter", new SunRMIExporter());
        return super.startNewServerImpl(mbs, env, url);
    }

    private Properties getAgentProperties() {
        if (this.agentProperties != null) {
            return this.agentProperties;
        }
        try {
            Class<?> c = Class.forName("sun.misc.VMSupport", false, null);
            this.agentProperties = (Properties)c.getMethod("getAgentProperties", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.agentProperties = new Properties();
        }
        return this.agentProperties;
    }
}

