/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server.jdp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.Connector;
import oracle.jrockit.management.server.Messages;
import oracle.jrockit.management.server.Option;

public class JDPConnector
extends Connector
implements Runnable {
    private static final char DELIMITER = '!';
    private final Connector remoteJMXConnector;
    private boolean started;
    private int port;
    private int period;
    private int ttl;
    private String address;
    private String name;
    private String nameSpace;
    private InetAddress inetAddress;
    private Thread thread;
    private MulticastSocket socket;

    public JDPConnector(Connector remoteJMXConnector) {
        this.remoteJMXConnector = remoteJMXConnector;
    }

    public String address() {
        return this.address;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public String host() {
        return this.inetAddress.toString();
    }

    public int port() {
        return this.port;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start(Properties p) {
        if (this.started) {
            return;
        }
        if (!this.remoteJMXConnector.isStarted()) {
            Messages.info("agent.info.jdp.needs.jmx", new Object[0]);
            return;
        }
        this.port = Option.JDP_PORT.asInt(p);
        this.period = Option.JDP_PERIOD.asInt(p);
        this.name = Option.JDP_NAME.valueOf(p);
        this.nameSpace = Option.JDP_PROPERY_NS.valueOf(p);
        try {
            this.address = Option.JDP_ADDRESS.valueOf(p);
            this.inetAddress = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException e) {
            throw new AgentError("agent.err.invalid.option", Option.JDP_ADDRESS.simpleName(), e);
        }
        this.ttl = Option.JDP_TTL.asInt(p);
        try {
            this.socket = new MulticastSocket(this.port);
            this.socket.setTimeToLive(this.ttl);
            this.socket.joinGroup(this.inetAddress);
            this.thread = new Thread(this, "(JDP autodiscovery)");
            this.thread.setDaemon(true);
            this.thread.start();
        }
        catch (IOException e) {
            throw new AgentError(e);
        }
        this.started = true;
        Messages.info("agent.info.jdp.started", this.address, this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.started) {
            return;
        }
        JDPConnector jDPConnector = this;
        synchronized (jDPConnector) {
            this.started = false;
            this.notifyAll();
        }
        while (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        Messages.info("agent.info.jdp.stopped", new Object[0]);
    }

    private byte[] encode() throws IOException {
        Properties sysProps = System.getProperties();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        StringBuilder buf = new StringBuilder();
        buf.append('!');
        buf.append("version=").append(sysProps.getProperty("java.vm.version"));
        if (this.nameSpace != null) {
            for (Map.Entry e : sysProps.entrySet()) {
                String key = e.getKey().toString();
                if (!key.startsWith(this.nameSpace)) continue;
                buf.append(',');
                buf.append(e.getKey());
                buf.append("=");
                buf.append(e.getValue());
            }
        }
        buf.append('!');
        buf.append('1');
        buf.append('!');
        buf.append(this.remoteJMXConnector.getInetAddress().getHostAddress());
        buf.append('!');
        buf.append(this.remoteJMXConnector.port());
        if (this.name != null && this.name.length() > 0) {
            buf.append('!');
            buf.append(this.name);
        }
        dout.writeShort(0);
        dout.writeUTF(buf.toString());
        dout.flush();
        byte[] res = bout.toByteArray();
        res[0] = (byte)(res.length >> 8 & 0xFF);
        res[1] = (byte)(res.length & 0xFF);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        DatagramPacket packet = null;
        long last = System.currentTimeMillis();
        long recheck = 20000L;
        long time = Math.min(recheck, (long)this.period);
        while (this.started) {
            boolean send = true;
            try {
                long now;
                Object bytes;
                if (send && packet == null) {
                    bytes = this.encode();
                    packet = new DatagramPacket((byte[])bytes, ((byte[])bytes).length, this.inetAddress, this.port);
                }
                if (send && packet != null) {
                    this.socket.send(packet);
                }
                if (this.started) {
                    JDPConnector jDPConnector = this;
                    bytes = jDPConnector;
                    // MONITORENTER : jDPConnector
                    try {
                        this.wait(time);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if ((now = System.currentTimeMillis()) - last < (long)this.period) {
                    send = false;
                }
                if (packet != null && now - last >= recheck) {
                    try {
                        InetAddress addr = InetAddress.getByName(this.address);
                        if (!addr.equals(this.inetAddress)) {
                            packet = null;
                            this.socket.leaveGroup(this.inetAddress);
                            this.socket.joinGroup(addr);
                        }
                        this.inetAddress = addr;
                    }
                    catch (UnknownHostException e) {
                        Messages.error("agent.err.unknown.net.host", this.address);
                    }
                }
                last = now;
            }
            catch (Exception e) {
                Messages.error("agent.err.jdp.server.io.error", e);
            }
        }
    }
}

