/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.JMXConnector;
import oracle.jrockit.management.server.Messages;
import oracle.jrockit.management.server.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteJMXConnector
extends JMXConnector {
    private int registryPort;
    private int serverPort;

    protected RemoteJMXConnector() {
        super("agent.info.remote.jmx.started");
    }

    @Override
    public int port() {
        return this.registryPort;
    }

    public int serverPort() {
        return this.serverPort;
    }

    @Override
    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                throw new AgentError("agent.err.connector.server.io.error", e.getMessage(), e);
            }
            this.server = null;
            Messages.info("agent.info.remote.jmx.stopped", new Object[0]);
        }
    }

    private int parsePort(String s, Properties p) {
        int port;
        try {
            port = Integer.parseInt(s);
        }
        catch (NumberFormatException x) {
            port = -1;
        }
        if (port < 0) {
            throw new AgentError("agent.err.invalid.jmxremote.port", s);
        }
        return port;
    }

    @Override
    protected final JMXConnectorServer startNewServer(Properties p) {
        JMXConnectorServer cs;
        String s = Option.JMXREMOTE_PORT.valueOf(p);
        int port = "".equals(s) ? Integer.parseInt(Option.JMXREMOTE_PORT.defaultValue()) : this.parsePort(s, p);
        String host = null;
        s = Option.JMXREMOTE_INTERFACE.valueOf(p);
        if (s != null) {
            host = s;
        }
        boolean useAuthentication = Boolean.valueOf(Option.USE_AUTHENTICATION.valueOf(p));
        boolean useSsl = Boolean.valueOf(Option.USE_SSL.valueOf(p));
        boolean useRegistrySsl = Boolean.valueOf(Option.USE_REGISTRY_SSL.valueOf(p));
        int serverPort = port;
        s = Option.JMXREMOTE_RMISERVER_PORT.valueOf(p);
        if (s == null && useSsl != useRegistrySsl) {
            serverPort = 0;
        }
        if (s != null) {
            serverPort = this.parsePort(s, p);
        }
        this.registryPort = port;
        this.serverPort = serverPort;
        String enabledCipherSuites = Option.SSL_ENABLED_CIPHER_SUITES.valueOf(p);
        String[] enabledCipherSuitesList = null;
        if (enabledCipherSuites != null) {
            enabledCipherSuitesList = enabledCipherSuites.split(",");
        }
        String enabledProtocols = Option.SSL_ENABLED_PROTOCOLS.valueOf(p);
        String[] enabledProtocolsList = null;
        if (enabledProtocols != null) {
            enabledProtocolsList = enabledProtocols.split(",");
        }
        boolean sslNeedClientAuth = Boolean.valueOf(Option.SSL_NEED_CLIENT_AUTH.valueOf(p));
        String sslConfigFileName = Option.SSL_CONFIG_FILE_NAME.valueOf(p);
        String loginConfigName = null;
        String passwordFileName = null;
        String accessFileName = null;
        if (useAuthentication) {
            loginConfigName = Option.LOGIN_CONFIG_NAME.valueOf(p);
            if (loginConfigName == null) {
                passwordFileName = Option.PASSWORD_FILE_NAME.valueOf(p);
                this.checkPasswordFile(passwordFileName);
            }
            accessFileName = Option.ACCESS_FILE_NAME.valueOf(p);
            this.checkAccessFile(accessFileName);
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            cs = this.newServer(mbs, env, host, port, serverPort, useSsl, useRegistrySsl, sslConfigFileName, enabledCipherSuitesList, enabledProtocolsList, sslNeedClientAuth, useAuthentication, loginConfigName, passwordFileName, accessFileName);
        }
        catch (Exception e) {
            throw new AgentError(e);
        }
        return cs;
    }

    protected void checkPasswordFile(String passwordFileName) {
        if (passwordFileName == null || passwordFileName.length() == 0) {
            throw new AgentError("agent.err.password.file.notset");
        }
        File file = new File(passwordFileName);
        if (!file.exists()) {
            throw new AgentError("agent.err.password.file.notfound", passwordFileName);
        }
        if (!file.canRead()) {
            throw new AgentError("agent.err.password.file.not.readable", passwordFileName);
        }
    }

    protected JMXConnectorServer newServer(MBeanServer mbs, Map<String, Object> env, String host, int port, int serverPort, boolean useSsl, boolean useRegistrySsl, String sslConfigFileName, String[] enabledCipherSuites, String[] enabledProtocols, boolean sslNeedClientAuth, boolean useAuthentication, String loginConfigName, String passwordFileName, String accessFileName) throws IOException, MalformedURLException {
        JMXServiceURL url = new JMXServiceURL("rmi", host, serverPort);
        SslRMIClientSocketFactory csf = null;
        SslRMIServerSocketFactory ssf = null;
        if (useSsl || useRegistrySsl) {
            csf = new SslRMIClientSocketFactory();
            ssf = new SslRMIServerSocketFactory(enabledCipherSuites, enabledProtocols, sslNeedClientAuth);
        }
        if (useSsl) {
            env.put("jmx.remote.rmi.client.socket.factory", csf);
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        JMXConnectorServer cs = null;
        try {
            cs = super.startNewServerImpl(mbs, env, url);
        }
        catch (IOException e) {
            if (cs == null) {
                throw new AgentError("agent.err.connector.server.io.error", url.toString(), e);
            }
            throw new AgentError("agent.err.connector.server.io.error", cs.getAddress().toString(), e);
        }
        return cs;
    }

    private void checkAccessFile(String accessFileName) {
        if (accessFileName == null || accessFileName.length() == 0) {
            throw new AgentError("agent.err.access.file.notset");
        }
        File file = new File(accessFileName);
        if (!file.exists()) {
            throw new AgentError("agent.err.access.file.notfound", accessFileName);
        }
        if (!file.canRead()) {
            throw new AgentError("agent.err.access.file.not.readable", accessFileName);
        }
    }
}

