/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.jrockit.management.server.AgentError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Option {
    CONFIG_FILE("config.file", "!management.properties"),
    JMXREMOTE("jmxremote"),
    JMXREMOTE_PORT("jmxremote.port", "7091"),
    JMXREMOTE_RMISERVER_PORT("jmxremote.rmiserver.port", 1),
    JMXREMOTE_INTERFACE("jmxremote.interface", 1),
    ENABLE_THREAD_CONTENTION_MONITORING("enableThreadContentionMonitoring"),
    USE_SSL("jmxremote.ssl", "true"),
    USE_REGISTRY_SSL("jmxremote.registry.ssl", "false"),
    USE_AUTHENTICATION("jmxremote.authenticate", "true"),
    PASSWORD_FILE_NAME("jmxremote.password.file", "!jmxremote.password"),
    ACCESS_FILE_NAME("jmxremote.access.file", "!jmxremote.access"),
    LOGIN_CONFIG_NAME("jmxremote.login.config"),
    SSL_ENABLED_CIPHER_SUITES("jmxremote.ssl.enabled.cipher.suites"),
    SSL_ENABLED_PROTOCOLS("jmxremote.ssl.enabled.protocols"),
    SSL_NEED_CLIENT_AUTH("jmxremote.ssl.need.client.auth", "false"),
    SSL_CONFIG_FILE_NAME("jmxremote.ssl.config.file"),
    SNMP_PORT("snmp.port"),
    SNMP_TRAP_PORT("snmp.trap"),
    SNMP_USE_ACL("snmp.acl", 1),
    SNMP_ACL_FILE_NAME("snmp.acl.file"),
    SNMP_BIND_ADDRESS("snmp.interface"),
    AUTODISCOVERY("autodiscovery", 1),
    JDP_PERIOD("autodiscovery.period", "5000", 1),
    JDP_TTL("autodiscovery.ttl", "1", 1),
    JDP_ADDRESS("autodiscovery.address", "232.192.1.212", 1),
    JDP_PORT("autodiscovery.port", "7095", 1),
    JDP_NAME("autodiscovery.name", 1),
    JDP_PROPERY_NS("autodiscovery.property.prefix", 1);

    private final String name;
    private final String defaultValue;
    private final int firstNameSpace;
    private static final String COMORACLE = "com.oracle.management.";
    private static final String COMSUN = "com.sun.management.";
    private static final String JROCKITMGMT = "jrockit.managementserver.";
    private static final String[] nameSpaces;
    private static final int NS_ORACLE_ONLY = 1;
    private static final int NS_BOTH = 0;

    private Option(String name, String val, int firstNameSpace) {
        this.name = name;
        this.defaultValue = val;
        this.firstNameSpace = firstNameSpace;
    }

    private Option(String name, String val) {
        this(name, val, 0);
    }

    private Option(String name, int firstNameSpace) {
        this(name, null, firstNameSpace);
    }

    private Option(String name) {
        this(name, null);
    }

    public boolean match(String s) {
        if (s.equals(this.name)) {
            return true;
        }
        return this.name.startsWith("jmxremote.") && this.name.length() == s.length() + "jmxremote.".length() && this.name.endsWith(s);
    }

    public String qualifiedName() {
        return COMORACLE + this.name;
    }

    public String qualifiedSunName() {
        if (this.firstNameSpace > 0) {
            throw new IllegalArgumentException();
        }
        return COMSUN + this.name;
    }

    public String simpleName() {
        return this.name;
    }

    public String defaultValue() {
        if (this.defaultValue != null && this.defaultValue.charAt(0) == '!') {
            return Option.getDefaultFileName(this.defaultValue.substring(1));
        }
        return this.defaultValue;
    }

    public String valueOf(Properties p, String dv) {
        int n = nameSpaces.length;
        for (int i = this.firstNameSpace; i < n; ++i) {
            String k = nameSpaces[i];
            String v = p.getProperty(k + this.name);
            if (v == null) continue;
            return v;
        }
        return dv;
    }

    public String valueOf(Properties p) {
        return this.valueOf(p, this.defaultValue());
    }

    public int asInt(Properties p) {
        try {
            return Integer.parseInt(this.valueOf(p));
        }
        catch (NumberFormatException e) {
            throw new AgentError("agent.err.invalid.option", this.name, e);
        }
    }

    public boolean isSet(Properties p) {
        return this.valueOf(p, null) != null;
    }

    public boolean isFalse(Properties p) {
        String v = this.valueOf(p, null);
        return v != null && (v.equalsIgnoreCase("false") || v.equals("0"));
    }

    public boolean isTrue(Properties p) {
        String v = this.valueOf(p, null);
        return v != null && (v.equalsIgnoreCase("true") || v.equals("1"));
    }

    public boolean isTrueOrEmpty(Properties p) {
        String v = this.valueOf(p, null);
        return v != null && (v.equalsIgnoreCase("true") || v.equals("1") || v.length() == 0);
    }

    public static Properties ensureSunOptions(Properties p) {
        return Option.translatePrefix(p, COMORACLE, COMSUN);
    }

    public static Properties convertLegacyPrefix(Properties p) {
        return Option.translatePrefix(p, JROCKITMGMT, COMORACLE);
    }

    private static Properties translatePrefix(Properties p, String find, String replace) {
        Properties np = new Properties();
        for (Map.Entry e : p.entrySet()) {
            String s;
            Object k = e.getKey();
            if (k instanceof String && (s = (String)k).startsWith(find)) {
                k = replace.concat(s.substring(find.length()));
            }
            np.put(k, e.getValue());
        }
        return np;
    }

    static String replaceArg(String name) {
        if (name.startsWith(COMSUN) || name.startsWith(COMORACLE)) {
            return name;
        }
        for (Option o : Option.values()) {
            if (!o.match(name)) continue;
            return o.qualifiedName();
        }
        return null;
    }

    private static String getDefaultFileName(String basename) {
        char fileSeparator = File.separatorChar;
        return System.getProperty("java.home") + fileSeparator + "lib" + fileSeparator + "management" + fileSeparator + basename;
    }

    static {
        nameSpaces = new String[]{COMSUN, COMORACLE};
    }
}

