/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;
import oracle.jrockit.management.server.AgentError;

public class Messages {
    public static final String AGENT_EXCEPTION = "agent.err.exception";
    public static final String CONFIG_FILE_NOT_FOUND = "agent.err.configfile.notfound";
    public static final String CONFIG_FILE_OPEN_FAILED = "agent.err.configfile.failed";
    public static final String CONFIG_FILE_CLOSE_FAILED = "agent.err.configfile.closed.failed";
    public static final String CONFIG_FILE_ACCESS_DENIED = "agent.err.configfile.access.denied";
    public static final String EXPORT_ADDRESS_FAILED = "agent.err.exportaddress.failed";
    public static final String AGENT_CLASS_NOT_FOUND = "agent.err.agentclass.notfound";
    public static final String AGENT_CLASS_FAILED = "agent.err.agentclass.failed";
    public static final String AGENT_CLASS_PREMAIN_NOT_FOUND = "agent.err.premain.notfound";
    public static final String AGENT_CLASS_ACCESS_DENIED = "agent.err.agentclass.access.denied";
    public static final String AGENT_CLASS_INVALID = "agent.err.invalid.agentclass";
    public static final String INVALID_JMXREMOTE_PORT = "agent.err.invalid.jmxremote.port";
    public static final String INVALID_JMXREMOTE_HOST = "agent.err.invalid.jmxremote.host";
    public static final String PASSWORD_FILE_NOT_SET = "agent.err.password.file.notset";
    public static final String PASSWORD_FILE_NOT_READABLE = "agent.err.password.file.not.readable";
    public static final String PASSWORD_FILE_READ_FAILED = "agent.err.password.file.read.failed";
    public static final String PASSWORD_FILE_NOT_FOUND = "agent.err.password.file.notfound";
    public static final String ACCESS_FILE_NOT_SET = "agent.err.access.file.notset";
    public static final String ACCESS_FILE_NOT_READABLE = "agent.err.access.file.not.readable";
    public static final String ACCESS_FILE_READ_FAILED = "agent.err.access.file.read.failed";
    public static final String ACCESS_FILE_NOT_FOUND = "agent.err.access.file.notfound";
    public static final String PASSWORD_FILE_ACCESS_NOT_RESTRICTED = "agent.err.password.file.access.notrestricted";
    public static final String FILE_ACCESS_NOT_RESTRICTED = "agent.err.file.access.not.restricted";
    public static final String FILE_NOT_FOUND = "agent.err.file.not.found";
    public static final String FILE_NOT_READABLE = "agent.err.file.not.readable";
    public static final String FILE_NOT_SET = "agent.err.file.not.set";
    public static final String FILE_READ_FAILED = "agent.err.file.read.failed";
    public static final String CONNECTOR_SERVER_IO_ERROR = "agent.err.connector.server.io.error";
    public static final String INVALID_OPTION = "agent.err.invalid.option";
    public static final String INVALID_SNMP_PORT = "agent.err.invalid.snmp.port";
    public static final String INVALID_SNMP_TRAP_PORT = "agent.err.invalid.snmp.trap.port";
    public static final String UNKNOWN_SNMP_INTERFACE = "agent.err.unknown.snmp.interface";
    public static final String SNMP_ACL_FILE_NOT_SET = "agent.err.acl.file.notset";
    public static final String SNMP_ACL_FILE_NOT_FOUND = "agent.err.acl.file.notfound";
    public static final String SNMP_ACL_FILE_NOT_READABLE = "agent.err.acl.file.not.readable";
    public static final String SNMP_ACL_FILE_READ_FAILED = "agent.err.acl.file.read.failed";
    public static final String SNMP_ACL_FILE_ACCESS_NOT_RESTRICTED = "agent.err.acl.file.access.notrestricted";
    public static final String SNMP_ADAPTOR_START_FAILED = "agent.err.snmp.adaptor.start.failed";
    public static final String SNMP_MIB_INIT_FAILED = "agent.err.snmp.mib.init.failed";
    public static final String UNKNOWN_NET_INTERFACE = "agent.err.unknown.net.interface";
    public static final String UNKNOWN_HOST = "agent.err.unknown.net.host";
    public static final String JDP_SERVER_IO_ERROR = "agent.err.jdp.server.io.error";
    public static final String STARTED_REMOTE_JMX_CONNECTOR = "agent.info.remote.jmx.started";
    public static final String STARTED_LOCAL_JMX_CONNECTOR = "agent.info.local.jmx.started";
    public static final String STARTED_SNMP_CONNECTOR = "agent.info.snmp.started";
    public static final String STARTED_JDP_CONNECTOR = "agent.info.jdp.started";
    public static final String JDP_CONNECTOR_NEEDS_REMOTE_JMX = "agent.info.jdp.needs.jmx";
    public static final String STOPPED_REMOTE_JMX_CONNECTOR = "agent.info.remote.jmx.stopped";
    public static final String STOPPED_LOCAL_JMX_CONNECTOR = "agent.info.local.jmx.stopped";
    public static final String STOPPED_SNMP_CONNECTOR = "agent.info.snmp.stopped";
    public static final String STOPPED_JDP_CONNECTOR = "agent.info.jdp.stopped";
    public static final String TOO_MANY_ARGUMENTS = "agent.err.toomanyargs";
    public static final String ARG_MUST_BE_FIRST = "agent.err.argmustbefirst";
    public static final String LOCAL_JMX_CONNECTOR_RUNNING = "agent.info.local.jmx.running";
    public static final String CANNOT_STOP_LOCAL_JMX_CONNECTOR = "agent.info.local.jmx.cannot.stop";
    public static final String LOCAL_JMX_CONNECTOR_REFUSE_REMOTE = "agent.err.local.jmx.refuse.remote";
    public static final String AGENT_ALREADY_RUNNING = "agent.info.alreadyrunning";
    public static final String REFUSED_CONNECTION = "agent.refused.connection";
    private static final String AGENT_ERROR = "agent.err.error";
    private static final String AGENT_WARNING = "agent.err.warning";
    private static final String AGENT_INFO = "agent.err.info";
    private static final Logger logger = Logger.loggerFor("management");
    static ResourceBundle resources;

    private static String msg(String what, String key, Object ... params) {
        String keyText = Messages.getText(key);
        if (params != null || params.length > 0) {
            keyText = MessageFormat.format(keyText, params);
        }
        if (what == AGENT_INFO) {
            logger.forceLog(MsgLevel.INFO, keyText, new Object[0]);
        } else if (what == AGENT_WARNING) {
            logger.warn(keyText);
        } else {
            logger.error(keyText);
        }
        String s = Messages.getText(what) + ": " + keyText;
        return s;
    }

    public static void error(String key, Object ... params) {
        throw new RuntimeException(Messages.msg(AGENT_ERROR, key, params));
    }

    public static void error(Throwable e) {
        try {
            Messages.error(AGENT_EXCEPTION, e.getMessage());
        }
        catch (RuntimeException re) {
            re.initCause(e);
            throw re;
        }
    }

    public static void error(AgentError e) {
        try {
            Messages.error(e.getKey(), e.getMessage());
        }
        catch (RuntimeException re) {
            re.initCause(e);
            throw re;
        }
    }

    public static void warning(String key, Object ... params) {
        Messages.msg(AGENT_WARNING, key, params);
    }

    public static void info(String key, Object ... params) {
        Messages.msg(AGENT_INFO, key, params);
    }

    public static String getText(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("oracle.jrockit.management.resources.messages");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for management agent is missing");
            }
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return "Missing management agent resource bundle: key = \"" + key + "\"";
        }
    }
}

