/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.JMXConnector;
import oracle.jrockit.management.server.Messages;

public abstract class LocalJMXConnector
extends JMXConnector {
    protected LocalJMXConnector() {
        super("agent.info.local.jmx.started");
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            Messages.info("agent.info.local.jmx.cannot.stop", new Object[0]);
        }
    }

    protected final JMXConnectorServer startNewServer(Properties p) {
        String localhost = "localhost";
        InetAddress lh = null;
        try {
            lh = InetAddress.getByName(localhost);
            localhost = lh.getHostAddress();
        }
        catch (UnknownHostException x) {
            // empty catch block
        }
        if (lh == null || !lh.isLoopbackAddress()) {
            localhost = "127.0.0.1";
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", localhost, 0);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("jmx.remote.rmi.server.socket.factory", new LocalRMIServerSocketFactory());
            return this.startNewServerImpl(mbs, env, url);
        }
        catch (Exception e) {
            throw new AgentError(e);
        }
    }

    private static final class LocalRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private LocalRMIServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port){

                public Socket accept() throws IOException {
                    Enumeration<NetworkInterface> nis;
                    Socket socket = super.accept();
                    InetAddress remoteAddr = socket.getInetAddress();
                    String msg = "The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.";
                    try {
                        nis = NetworkInterface.getNetworkInterfaces();
                    }
                    catch (SocketException e) {
                        try {
                            socket.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        Messages.warning("agent.err.local.jmx.refuse.remote", remoteAddr);
                        throw (IOException)new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.").initCause(e);
                    }
                    while (nis.hasMoreElements()) {
                        NetworkInterface ni = nis.nextElement();
                        Enumeration<InetAddress> addrs = ni.getInetAddresses();
                        while (addrs.hasMoreElements()) {
                            InetAddress localAddr = addrs.nextElement();
                            if (!localAddr.equals(remoteAddr)) continue;
                            return socket;
                        }
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    Messages.warning("agent.err.local.jmx.refuse.remote", remoteAddr);
                    throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.");
                }
            };
        }

        public boolean equals(Object obj) {
            return obj instanceof LocalRMIServerSocketFactory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

