/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.Connector;
import oracle.jrockit.management.server.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXConnector
extends Connector {
    protected JMXConnectorServer server;
    private final String startKey;

    public JMXConnector(String startKey) {
        this.startKey = startKey;
    }

    @Override
    public String address() {
        return this.server != null ? this.server.getAddress().toString() : null;
    }

    @Override
    public String host() {
        return this.server != null ? this.server.getAddress().getHost() : null;
    }

    @Override
    public int port() {
        return this.server != null ? Integer.valueOf(this.server.getAddress().getPort()) : null;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public synchronized void start(Properties p) {
        if (this.server != null) {
            return;
        }
        System.setProperty("java.rmi.server.randomIDs", "true");
        this.server = this.startNewServer(p);
        Messages.info(this.startKey, this.host(), this.port());
    }

    @Override
    public boolean isStarted() {
        return this.server != null;
    }

    protected abstract JMXConnectorServer startNewServer(Properties var1);

    protected JMXConnectorServer startNewServerImpl(MBeanServer mbs, Map<String, Object> env, JMXServiceURL url) throws IOException {
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        try {
            cs.start();
        }
        catch (IOException e) {
            throw new AgentError("agent.err.connector.server.io.error", null, e);
        }
        return cs;
    }
}

