/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.Messages;

public class HostServerSocketFactory
implements RMIServerSocketFactory {
    private final String host;
    private final RMIServerSocketFactory ssf;
    private final InetAddress[] addresses;

    public HostServerSocketFactory(String host, RMIServerSocketFactory ssf) {
        this.host = host;
        this.ssf = ssf;
        boolean found = false;
        InetAddress[] addresses = null;
        try {
            for (InetAddress a : addresses = InetAddress.getAllByName(host)) {
                try {
                    if (NetworkInterface.getByInetAddress(a) == null) continue;
                    found = true;
                    break;
                }
                catch (SocketException e) {
                    // empty catch block
                }
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (!found) {
            throw new AgentError("agent.err.invalid.jmxremote.host", host);
        }
        this.addresses = addresses;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket ss = this.ssf != null ? this.ssf.createServerSocket(port) : new ServerSocket(port);
        return new ServerSocketDelegate(ss);
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.host + " (" + Arrays.toString(this.addresses) + ")";
    }

    private class ServerSocketDelegate
    extends ServerSocket {
        private final ServerSocket socket;

        public ServerSocketDelegate(ServerSocket socket) throws IOException {
            this.socket = socket;
        }

        public Socket accept() throws IOException {
            while (true) {
                Socket s = this.socket.accept();
                InetAddress local = s.getLocalAddress();
                InetAddress remote = s.getInetAddress();
                for (InetAddress a : HostServerSocketFactory.this.addresses) {
                    if (!a.equals(local)) continue;
                    return s;
                }
                s.close();
                Messages.warning("agent.refused.connection", remote, local);
            }
        }

        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.socket.bind(endpoint, backlog);
        }

        public void bind(SocketAddress endpoint) throws IOException {
            this.socket.bind(endpoint);
        }

        public void close() throws IOException {
            this.socket.close();
        }

        public boolean equals(Object obj) {
            return this.socket.equals(obj);
        }

        public ServerSocketChannel getChannel() {
            return this.socket.getChannel();
        }

        public InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.socket.getLocalSocketAddress();
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.socket.getReceiveBufferSize();
        }

        public boolean getReuseAddress() throws SocketException {
            return this.socket.getReuseAddress();
        }

        public int getSoTimeout() throws IOException {
            return this.socket.getSoTimeout();
        }

        public int hashCode() {
            return this.socket.hashCode();
        }

        public boolean isBound() {
            return this.socket.isBound();
        }

        public boolean isClosed() {
            return this.socket.isClosed();
        }

        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        public void setReceiveBufferSize(int size) throws SocketException {
            this.socket.setReceiveBufferSize(size);
        }

        public void setReuseAddress(boolean on) throws SocketException {
            this.socket.setReuseAddress(on);
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.socket.setSoTimeout(timeout);
        }

        public String toString() {
            return this.socket.toString();
        }
    }
}

